/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import java.util.ArrayList;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean startsWithIgnoreWhitespaces(String prefix, String string) {
        int index2;
        int index1 = 0;
        int length1 = prefix.length();
        int length2 = string.length();
        int ch1 = 32;
        int ch2 = 32;
        for (index2 = 0; index1 < length1 && index2 < length2; ++index1, ++index2) {
            while (index1 < length1) {
                char c = prefix.charAt(index1);
                ch1 = c;
                if (!Character.isWhitespace(c)) break;
                ++index1;
            }
            while (index2 < length2) {
                char c = string.charAt(index2);
                ch2 = c;
                if (!Character.isWhitespace(c)) break;
                ++index2;
            }
            if (index1 == length1 && index2 == length2) {
                return true;
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return index1 >= length1 || index2 < length2;
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }
}

