/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.BaseHazelcastProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.hz.HazelcastConfigurationFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.CoreTicketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="hazelcastTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class HazelcastTicketRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="ticketCatalog")
    private ObjectProvider<TicketCatalog> ticketCatalog;

    @Bean
    @RefreshScope
    public TicketRegistry ticketRegistry() {
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastConfigurationFactory factory = new HazelcastConfigurationFactory();
        HazelcastInstance hazelcastInstance = this.casTicketRegistryHazelcastInstance();
        TicketCatalog catalog = (TicketCatalog)this.ticketCatalog.getObject();
        catalog.findAll().stream().map(TicketDefinition::getProperties).peek(p -> LOGGER.debug("Created Hazelcast map configuration for [{}]", p)).map(p -> factory.buildMapConfig((BaseHazelcastProperties)hz, p.getStorageName(), p.getStorageTimeout())).forEach(m -> hazelcastInstance.getConfig().addMapConfig(m));
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(hazelcastInstance, catalog, hz.getPageSize());
        r.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)hz.getCrypto(), (String)"hazelcast"));
        return r;
    }

    @ConditionalOnMissingBean(name={"casTicketRegistryHazelcastInstance"})
    @Bean
    public HazelcastInstance casTicketRegistryHazelcastInstance() {
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        LOGGER.debug("Creating Hazelcast instance for members [{}]", (Object)hz.getCluster().getMembers());
        return Hazelcast.newHazelcastInstance((Config)HazelcastConfigurationFactory.build((BaseHazelcastProperties)hz));
    }

    @Bean
    public TicketRegistryCleaner ticketRegistryCleaner() {
        return NoOpTicketRegistryCleaner.getInstance();
    }
}

