/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class QueryAndEncodeDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    protected String algorithmName;
    protected String sql;
    protected String passwordFieldName = "password";
    protected String saltFieldName = "salt";
    protected String expiredFieldName;
    protected String disabledFieldName;
    protected String numberOfIterationsFieldName;
    protected int numberOfIterations;
    protected String staticSalt;

    public QueryAndEncodeDatabaseAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, DataSource dataSource, String algorithmName, String sql, String passwordFieldName, String saltFieldName, String expiredFieldName, String disabledFieldName, String numberOfIterationsFieldName, int numberOfIterations, String staticSalt) {
        super(name, servicesManager, principalFactory, order, dataSource);
        this.algorithmName = algorithmName;
        this.sql = sql;
        this.passwordFieldName = passwordFieldName;
        this.saltFieldName = saltFieldName;
        this.expiredFieldName = expiredFieldName;
        this.disabledFieldName = disabledFieldName;
        this.numberOfIterationsFieldName = numberOfIterationsFieldName;
        this.numberOfIterations = numberOfIterations;
        this.staticSalt = staticSalt;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential, String originalPassword) throws GeneralSecurityException, PreventedException {
        if (StringUtils.isBlank((CharSequence)this.sql) || StringUtils.isBlank((CharSequence)this.algorithmName) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly");
        }
        String username = transformedCredential.getUsername();
        try {
            String dbDisabled;
            String dbExpired;
            Map values = this.getJdbcTemplate().queryForMap(this.sql, new Object[]{username});
            String digestedPassword = this.digestEncodedPassword(transformedCredential.getPassword(), values);
            if (!values.get(this.passwordFieldName).equals(digestedPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
            if (StringUtils.isNotBlank((CharSequence)this.expiredFieldName) && values.containsKey(this.expiredFieldName) && (BooleanUtils.toBoolean((String)(dbExpired = values.get(this.expiredFieldName).toString())) || "1".equals(dbExpired))) {
                throw new AccountPasswordMustChangeException("Password has expired");
            }
            if (StringUtils.isNotBlank((CharSequence)this.disabledFieldName) && values.containsKey(this.disabledFieldName) && (BooleanUtils.toBoolean((String)(dbDisabled = values.get(this.disabledFieldName).toString())) || "1".equals(dbDisabled))) {
                throw new AccountDisabledException("Account has been disabled");
            }
            return this.createHandlerResult((Credential)transformedCredential, this.principalFactory.createPrincipal(username), new ArrayList(0));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
    }

    protected String digestEncodedPassword(String encodedPassword, Map<String, Object> values) {
        DefaultHashService hashService = new DefaultHashService();
        if (StringUtils.isNotBlank((CharSequence)this.staticSalt)) {
            hashService.setPrivateSalt(ByteSource.Util.bytes((String)this.staticSalt));
        }
        hashService.setHashAlgorithmName(this.algorithmName);
        if (values.containsKey(this.numberOfIterationsFieldName)) {
            String longAsStr = values.get(this.numberOfIterationsFieldName).toString();
            hashService.setHashIterations(Integer.parseInt(longAsStr));
        } else {
            hashService.setHashIterations(this.numberOfIterations);
        }
        if (!values.containsKey(this.saltFieldName)) {
            throw new IllegalArgumentException("Specified field name for salt does not exist in the results");
        }
        String dynaSalt = values.get(this.saltFieldName).toString();
        HashRequest request = new HashRequest.Builder().setSalt((Object)dynaSalt).setSource((Object)encodedPassword).build();
        return hashService.computeHash(request).toHex();
    }
}

