/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import com.google.common.collect.Maps;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class QueryDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDatabaseAuthenticationHandler.class);
    private final String sql;
    private final String fieldPassword;
    private final String fieldExpired;
    private final String fieldDisabled;
    private final Map<String, Object> principalAttributeMap;

    public QueryDatabaseAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, DataSource dataSource, String sql, String fieldPassword, String fieldExpired, String fieldDisabled, Map<String, Object> attributes) {
        super(name, servicesManager, principalFactory, order, dataSource);
        this.sql = sql;
        this.fieldPassword = fieldPassword;
        this.fieldExpired = fieldExpired;
        this.fieldDisabled = fieldDisabled;
        this.principalAttributeMap = attributes;
        if (StringUtils.isBlank((CharSequence)this.fieldPassword)) {
            LOGGER.warn("When the password field is left undefined, CAS will skip comparing database and user passwords for equality , (specially if the query results do not contain the password field),and will instead only rely on a successful query execution with returned results in order to verify credentials");
        }
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException, PreventedException {
        if (StringUtils.isBlank((CharSequence)this.sql) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly. No SQL statement or JDBC template is found.");
        }
        HashMap attributes = Maps.newHashMapWithExpectedSize((int)this.principalAttributeMap.size());
        String username = credential.getUsername();
        String password = credential.getPassword();
        try {
            String dbExpired;
            String dbDisabled;
            Map<String, Object> dbFields = this.query(credential);
            if (dbFields.containsKey(this.fieldPassword)) {
                boolean originalPasswordEquals;
                String dbPassword = (String)dbFields.get(this.fieldPassword);
                boolean originalPasswordMatchFails = StringUtils.isNotBlank((CharSequence)originalPassword) && !this.matches(originalPassword, dbPassword);
                boolean bl = originalPasswordEquals = StringUtils.isBlank((CharSequence)originalPassword) && !StringUtils.equals((CharSequence)password, (CharSequence)dbPassword);
                if (originalPasswordMatchFails || originalPasswordEquals) {
                    throw new FailedLoginException("Password does not match value on record.");
                }
            } else {
                LOGGER.debug("Password field is not found in the query results. Checking for result count...");
                if (!dbFields.containsKey("total")) {
                    throw new FailedLoginException("Missing field 'total' from the query results for " + username);
                }
                Object count = dbFields.get("total");
                if (count == null || !NumberUtils.isCreatable((String)count.toString())) {
                    throw new FailedLoginException("Missing field value 'total' from the query results for " + username + " or value not parseable as a number");
                }
                Number number = NumberUtils.createNumber((String)count.toString());
                if (number.longValue() != 1L) {
                    throw new FailedLoginException("No records found for user " + username);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.fieldDisabled) && dbFields.containsKey(this.fieldDisabled) && (BooleanUtils.toBoolean((String)(dbDisabled = dbFields.get(this.fieldDisabled).toString())) || "1".equals(dbDisabled))) {
                throw new AccountDisabledException("Account has been disabled");
            }
            if (StringUtils.isNotBlank((CharSequence)this.fieldExpired) && dbFields.containsKey(this.fieldExpired) && (BooleanUtils.toBoolean((String)(dbExpired = dbFields.get(this.fieldExpired).toString())) || "1".equals(dbExpired))) {
                throw new AccountPasswordMustChangeException("Password has expired");
            }
            this.collectPrincipalAttributes(attributes, dbFields);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
        Principal principal = this.principalFactory.createPrincipal(username, (Map)attributes);
        return this.createHandlerResult((Credential)credential, principal, new ArrayList(0));
    }

    private Map<String, Object> query(UsernamePasswordCredential credential) {
        if (this.sql.contains("?")) {
            return this.getJdbcTemplate().queryForMap(this.sql, new Object[]{credential.getUsername()});
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("username", credential.getUsername());
        parameters.put("password", credential.getPassword());
        return this.getNamedJdbcTemplate().queryForMap(this.sql, parameters);
    }

    private void collectPrincipalAttributes(Map<String, List<Object>> attributes, Map<String, Object> dbFields) {
        this.principalAttributeMap.forEach((key, names) -> {
            Object attribute = dbFields.get(key);
            if (attribute != null) {
                LOGGER.debug("Found attribute [{}] from the query results", key);
                Collection attributeNames = (Collection)names;
                attributeNames.forEach(s -> {
                    LOGGER.debug("Principal attribute [{}] is virtually remapped/renamed to [{}]", key, s);
                    attributes.put((String)s, CollectionUtils.wrap((Object)attribute.toString()));
                });
            } else {
                LOGGER.warn("Requested attribute [{}] could not be found in the query results", key);
            }
        });
    }
}

