/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.apereo.cas.authentication.support.LdapPasswordPolicyHandlingStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationHandler.class);
    protected Map<String, Collection<String>> principalAttributeMap = new HashMap<String, Collection<String>>();
    protected LdapPasswordPolicyHandlingStrategy passwordPolicyHandlingStrategy;
    private final Authenticator authenticator;
    private String principalIdAttribute;
    private boolean allowMultiplePrincipalAttributeValues;
    private boolean allowMissingPrincipalAttributeValue = true;
    private String[] authenticatedEntryAttributes = ReturnAttributes.NONE.value();
    private boolean collectDnAttribute;
    private String principalDnAttributeName = "principalLdapDn";

    public LdapAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, Authenticator authenticator, LdapPasswordPolicyHandlingStrategy strategy) {
        super(name, servicesManager, principalFactory, order);
        this.authenticator = authenticator;
        this.passwordPolicyHandlingStrategy = strategy;
    }

    public void setPrincipalIdAttribute(String attributeName) {
        this.principalIdAttribute = attributeName;
    }

    public void setPrincipalDnAttributeName(String principalDnAttributeName) {
        this.principalDnAttributeName = principalDnAttributeName;
    }

    public void setAllowMultiplePrincipalAttributeValues(boolean allowed) {
        this.allowMultiplePrincipalAttributeValues = allowed;
    }

    public void setPrincipalAttributeMap(Map<String, Collection<String>> attributeNameMap) {
        this.principalAttributeMap = attributeNameMap;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential upc, String originalPassword) throws GeneralSecurityException, PreventedException {
        AuthenticationResponse response;
        try {
            LOGGER.debug("Attempting LDAP authentication for [{}]. Authenticator pre-configured attributes are [{}], additional requested attributes for this authentication request are [{}]", new Object[]{upc, this.authenticator.getReturnAttributes(), this.authenticatedEntryAttributes});
            AuthenticationRequest request = new AuthenticationRequest(upc.getUsername(), new org.ldaptive.Credential(upc.getPassword()), this.authenticatedEntryAttributes);
            response = this.authenticator.authenticate(request);
        }
        catch (LdapException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            throw new PreventedException("Unexpected LDAP error", (Throwable)e);
        }
        LOGGER.debug("LDAP response: [{}]", (Object)response);
        if (!this.passwordPolicyHandlingStrategy.supports(response)) {
            LOGGER.warn("Authentication has failed because LDAP password policy handling strategy [{}] cannot handle [{}].", (Object)response, (Object)this.passwordPolicyHandlingStrategy.getClass().getSimpleName());
            throw new FailedLoginException("Invalid credentials");
        }
        LOGGER.debug("Attempting to examine and handle LDAP password policy via [{}]", (Object)this.passwordPolicyHandlingStrategy.getClass().getSimpleName());
        List messageList = this.passwordPolicyHandlingStrategy.handle(response, (LdapPasswordPolicyConfiguration)this.getPasswordPolicyConfiguration());
        if (((Boolean)response.getResult()).booleanValue()) {
            LOGGER.debug("LDAP response returned a result. Creating the final LDAP principal");
            Principal principal = this.createPrincipal(upc.getUsername(), response.getLdapEntry());
            return this.createHandlerResult((Credential)upc, principal, messageList);
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode()) {
            LOGGER.warn("DN resolution failed. [{}]", (Object)response.getMessage());
            throw new AccountNotFoundException(upc.getUsername() + " not found.");
        }
        throw new FailedLoginException("Invalid credentials");
    }

    protected Principal createPrincipal(String username, LdapEntry ldapEntry) throws LoginException {
        LOGGER.debug("Creating LDAP principal for [{}] based on [{}] and attributes [{}]", new Object[]{username, ldapEntry.getDn(), ldapEntry.getAttributeNames()});
        String id = this.getLdapPrincipalIdentifier(username, ldapEntry);
        LOGGER.debug("LDAP principal identifier created is [{}]", (Object)id);
        Map<String, Object> attributeMap = this.collectAttributesForLdapEntry(ldapEntry, id);
        LOGGER.debug("Created LDAP principal for id [{}] and [{}] attributes", (Object)id, (Object)attributeMap.size());
        return this.principalFactory.createPrincipal(id, attributeMap);
    }

    protected Map<String, Object> collectAttributesForLdapEntry(LdapEntry ldapEntry, String username) {
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(this.principalAttributeMap.size());
        LOGGER.debug("The following attributes are requested to be retrieved and mapped: [{}]", attributeMap.keySet());
        this.principalAttributeMap.forEach((key, attributeNames) -> {
            LdapAttribute attr = ldapEntry.getAttribute(key);
            if (attr != null) {
                LOGGER.debug("Found principal attribute: [{}]", (Object)attr);
                if (attributeNames.isEmpty()) {
                    LOGGER.debug("Principal attribute [{}] is collected as [{}]", (Object)attr, key);
                    attributeMap.put((String)key, CollectionUtils.wrap((Object)attr.getStringValues()));
                } else {
                    attributeNames.forEach(s -> {
                        LOGGER.debug("Principal attribute [{}] is virtually remapped/renamed to [{}]", (Object)attr, s);
                        attributeMap.put((String)s, CollectionUtils.wrap((Object)attr.getStringValues()));
                    });
                }
            } else {
                LOGGER.warn("Requested LDAP attribute [{}] could not be found on the resolved LDAP entry for [{}]", key, (Object)ldapEntry.getDn());
            }
        });
        if (this.collectDnAttribute) {
            LOGGER.debug("Recording principal DN attribute as [{}]", (Object)this.principalDnAttributeName);
            attributeMap.put(this.principalDnAttributeName, ldapEntry.getDn());
        }
        return attributeMap;
    }

    protected String getLdapPrincipalIdentifier(String username, LdapEntry ldapEntry) throws LoginException {
        if (StringUtils.isNotBlank((CharSequence)this.principalIdAttribute)) {
            LdapAttribute principalAttr = ldapEntry.getAttribute(this.principalIdAttribute);
            if (principalAttr == null || principalAttr.size() == 0) {
                if (this.allowMissingPrincipalAttributeValue) {
                    LOGGER.warn("The principal id attribute [{}] is not found. CAS cannot construct the final authenticated principal if it's unable to locate the attribute that is designated as the principal id. Attributes available on the LDAP entry are [{}]. Since principal id attribute is not available, CAS will fall back to construct the principal based on the provided user id: [{}]", new Object[]{this.principalIdAttribute, ldapEntry.getAttributes(), username});
                    return username;
                }
                LOGGER.error("The principal id attribute [{}] is not found. CAS is configured to disallow missing principal attributes", (Object)this.principalIdAttribute);
                throw new LoginException("Principal id attribute is not found for " + principalAttr);
            }
            if (principalAttr.size() > 1) {
                if (!this.allowMultiplePrincipalAttributeValues) {
                    throw new LoginException("Multiple principal values are not allowed: " + principalAttr);
                }
                LOGGER.warn("Found multiple values for principal id attribute: [{}]. Using first value=[{}].", (Object)principalAttr, (Object)principalAttr.getStringValue());
            }
            LOGGER.debug("Retrieved principal id attribute [{}]", (Object)principalAttr.getStringValue());
            return principalAttr.getStringValue();
        }
        LOGGER.debug("Principal id attribute is not defined. Using the default provided user id [{}]", (Object)username);
        return username;
    }

    public void setAllowMissingPrincipalAttributeValue(boolean allowMissingPrincipalAttributeValue) {
        this.allowMissingPrincipalAttributeValue = allowMissingPrincipalAttributeValue;
    }

    @PostConstruct
    public void initialize() {
        List authenticatorAttributes;
        HashSet<String> attributes = new HashSet<String>();
        LOGGER.debug("Initializing LDAP attribute configuration...");
        if (StringUtils.isNotBlank((CharSequence)this.principalIdAttribute)) {
            LOGGER.debug("Configured to retrieve principal id attribute [{}]", (Object)this.principalIdAttribute);
            attributes.add(this.principalIdAttribute);
        }
        if (this.principalAttributeMap != null && !this.principalAttributeMap.isEmpty()) {
            Set<String> attrs = this.principalAttributeMap.keySet();
            attributes.addAll(attrs);
            LOGGER.debug("Configured to retrieve principal attribute collection of [{}]", attrs);
        }
        if (this.authenticator.getReturnAttributes() != null && !(authenticatorAttributes = CollectionUtils.wrapList((Object[])this.authenticator.getReturnAttributes())).isEmpty()) {
            LOGGER.debug("Filtering authentication entry attributes [{}] based on authenticator attributes [{}]", (Object)this.authenticatedEntryAttributes, (Object)authenticatorAttributes);
            attributes.removeIf(authenticatorAttributes::contains);
        }
        this.authenticatedEntryAttributes = attributes.toArray(new String[attributes.size()]);
        LOGGER.debug("LDAP authentication entry attributes for the authentication request are [{}]", (Object[])this.authenticatedEntryAttributes);
    }

    public void setCollectDnAttribute(boolean collectDnAttribute) {
        this.collectDnAttribute = collectDnAttribute;
    }
}

