/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.config.support.authentication;

import com.github.scribejava.core.model.Verb;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.pac4j.authentication.ClientAuthenticationMetaDataPopulator;
import org.apereo.cas.support.pac4j.authentication.handler.support.ClientAuthenticationHandler;
import org.apereo.cas.support.pac4j.web.flow.SAML2ClientLogoutAction;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Clients;
import org.pac4j.oauth.client.BitbucketClient;
import org.pac4j.oauth.client.DropBoxClient;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.FoursquareClient;
import org.pac4j.oauth.client.GenericOAuth20Client;
import org.pac4j.oauth.client.GitHubClient;
import org.pac4j.oauth.client.Google2Client;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.OrcidClient;
import org.pac4j.oauth.client.PayPalClient;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oauth.client.WindowsLiveClient;
import org.pac4j.oauth.client.WordPressClient;
import org.pac4j.oauth.client.YahooClient;
import org.pac4j.oidc.client.AzureAdClient;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.KeycloakOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.client.SAML2ClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.execution.Action;

@Configuration(value="pac4jAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class Pac4jAuthenticationEventExecutionPlanConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;

    private void configureGithubClient(Collection<BaseClient> properties) {
        Pac4jProperties.Github github = this.casProperties.getAuthn().getPac4j().getGithub();
        if (StringUtils.isNotBlank((CharSequence)github.getId()) && StringUtils.isNotBlank((CharSequence)github.getSecret())) {
            GitHubClient client = new GitHubClient(github.getId(), github.getSecret());
            this.setClientName((BaseClient)client, github.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureDropboxClient(Collection<BaseClient> properties) {
        Pac4jProperties.Dropbox db = this.casProperties.getAuthn().getPac4j().getDropbox();
        if (StringUtils.isNotBlank((CharSequence)db.getId()) && StringUtils.isNotBlank((CharSequence)db.getSecret())) {
            DropBoxClient client = new DropBoxClient(db.getId(), db.getSecret());
            this.setClientName((BaseClient)client, db.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureOrcidClient(Collection<BaseClient> properties) {
        Pac4jProperties.Orcid db = this.casProperties.getAuthn().getPac4j().getOrcid();
        if (StringUtils.isNotBlank((CharSequence)db.getId()) && StringUtils.isNotBlank((CharSequence)db.getSecret())) {
            OrcidClient client = new OrcidClient(db.getId(), db.getSecret());
            this.setClientName((BaseClient)client, db.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureWindowsLiveClient(Collection<BaseClient> properties) {
        Pac4jProperties.WindowsLive live = this.casProperties.getAuthn().getPac4j().getWindowsLive();
        if (StringUtils.isNotBlank((CharSequence)live.getId()) && StringUtils.isNotBlank((CharSequence)live.getSecret())) {
            WindowsLiveClient client = new WindowsLiveClient(live.getId(), live.getSecret());
            this.setClientName((BaseClient)client, live.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureYahooClient(Collection<BaseClient> properties) {
        Pac4jProperties.Yahoo yahoo = this.casProperties.getAuthn().getPac4j().getYahoo();
        if (StringUtils.isNotBlank((CharSequence)yahoo.getId()) && StringUtils.isNotBlank((CharSequence)yahoo.getSecret())) {
            YahooClient client = new YahooClient(yahoo.getId(), yahoo.getSecret());
            this.setClientName((BaseClient)client, yahoo.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureFoursquareClient(Collection<BaseClient> properties) {
        Pac4jProperties.Foursquare foursquare = this.casProperties.getAuthn().getPac4j().getFoursquare();
        if (StringUtils.isNotBlank((CharSequence)foursquare.getId()) && StringUtils.isNotBlank((CharSequence)foursquare.getSecret())) {
            FoursquareClient client = new FoursquareClient(foursquare.getId(), foursquare.getSecret());
            this.setClientName((BaseClient)client, foursquare.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureGoogleClient(Collection<BaseClient> properties) {
        Pac4jProperties.Google google = this.casProperties.getAuthn().getPac4j().getGoogle();
        Google2Client client = new Google2Client(google.getId(), google.getSecret());
        if (StringUtils.isNotBlank((CharSequence)google.getId()) && StringUtils.isNotBlank((CharSequence)google.getSecret())) {
            this.setClientName((BaseClient)client, google.getClientName());
            if (StringUtils.isNotBlank((CharSequence)google.getScope())) {
                client.setScope(Google2Client.Google2Scope.valueOf((String)google.getScope().toUpperCase()));
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureFacebookClient(Collection<BaseClient> properties) {
        Pac4jProperties.Facebook fb = this.casProperties.getAuthn().getPac4j().getFacebook();
        if (StringUtils.isNotBlank((CharSequence)fb.getId()) && StringUtils.isNotBlank((CharSequence)fb.getSecret())) {
            FacebookClient client = new FacebookClient(fb.getId(), fb.getSecret());
            this.setClientName((BaseClient)client, fb.getClientName());
            if (StringUtils.isNotBlank((CharSequence)fb.getScope())) {
                client.setScope(fb.getScope());
            }
            if (StringUtils.isNotBlank((CharSequence)fb.getFields())) {
                client.setFields(fb.getFields());
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureLinkedInClient(Collection<BaseClient> properties) {
        Pac4jProperties.LinkedIn ln = this.casProperties.getAuthn().getPac4j().getLinkedIn();
        if (StringUtils.isNotBlank((CharSequence)ln.getId()) && StringUtils.isNotBlank((CharSequence)ln.getSecret())) {
            LinkedIn2Client client = new LinkedIn2Client(ln.getId(), ln.getSecret());
            this.setClientName((BaseClient)client, ln.getClientName());
            if (StringUtils.isNotBlank((CharSequence)ln.getScope())) {
                client.setScope(ln.getScope());
            }
            if (StringUtils.isNotBlank((CharSequence)ln.getFields())) {
                client.setFields(ln.getFields());
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureTwitterClient(Collection<BaseClient> properties) {
        Pac4jProperties.Twitter twitter = this.casProperties.getAuthn().getPac4j().getTwitter();
        if (StringUtils.isNotBlank((CharSequence)twitter.getId()) && StringUtils.isNotBlank((CharSequence)twitter.getSecret())) {
            TwitterClient client = new TwitterClient(twitter.getId(), twitter.getSecret());
            this.setClientName((BaseClient)client, twitter.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureWordpressClient(Collection<BaseClient> properties) {
        Pac4jProperties.Wordpress wp = this.casProperties.getAuthn().getPac4j().getWordpress();
        if (StringUtils.isNotBlank((CharSequence)wp.getId()) && StringUtils.isNotBlank((CharSequence)wp.getSecret())) {
            WordPressClient client = new WordPressClient(wp.getId(), wp.getSecret());
            this.setClientName((BaseClient)client, wp.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configureBitbucketClient(Collection<BaseClient> properties) {
        Pac4jProperties.Bitbucket bb = this.casProperties.getAuthn().getPac4j().getBitbucket();
        if (StringUtils.isNotBlank((CharSequence)bb.getId()) && StringUtils.isNotBlank((CharSequence)bb.getSecret())) {
            BitbucketClient client = new BitbucketClient(bb.getId(), bb.getSecret());
            this.setClientName((BaseClient)client, bb.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void configurePaypalClient(Collection<BaseClient> properties) {
        Pac4jProperties.Paypal paypal = this.casProperties.getAuthn().getPac4j().getPaypal();
        if (StringUtils.isNotBlank((CharSequence)paypal.getId()) && StringUtils.isNotBlank((CharSequence)paypal.getSecret())) {
            PayPalClient client = new PayPalClient(paypal.getId(), paypal.getSecret());
            this.setClientName((BaseClient)client, paypal.getClientName());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            properties.add((BaseClient)client);
        }
    }

    private void setClientName(BaseClient client, String clientName) {
        if (StringUtils.isNotBlank((CharSequence)clientName)) {
            client.setName(clientName);
        }
    }

    private void configureCasClient(Collection<BaseClient> properties) {
        AtomicInteger index = new AtomicInteger();
        this.casProperties.getAuthn().getPac4j().getCas().stream().filter(cas -> StringUtils.isNotBlank((CharSequence)cas.getLoginUrl())).forEach(cas -> {
            CasConfiguration cfg = new CasConfiguration(cas.getLoginUrl(), CasProtocol.valueOf((String)cas.getProtocol()));
            CasClient client = new CasClient(cfg);
            int count = index.intValue();
            if (StringUtils.isNotBlank((CharSequence)cas.getClientName())) {
                client.setName(cas.getClientName());
            } else if (count > 0) {
                client.setName(client.getClass().getSimpleName() + count);
            }
            index.incrementAndGet();
            LOGGER.debug("Created client [{}]", (Object)client);
            properties.add((BaseClient)client);
        });
    }

    private void configureSamlClient(Collection<BaseClient> properties) {
        AtomicInteger index = new AtomicInteger();
        this.casProperties.getAuthn().getPac4j().getSaml().stream().filter(saml -> StringUtils.isNotBlank((CharSequence)saml.getKeystorePath()) && StringUtils.isNotBlank((CharSequence)saml.getIdentityProviderMetadataPath())).forEach(saml -> {
            SAML2ClientConfiguration cfg = new SAML2ClientConfiguration(saml.getKeystorePath(), saml.getKeystorePassword(), saml.getPrivateKeyPassword(), saml.getIdentityProviderMetadataPath());
            cfg.setMaximumAuthenticationLifetime(saml.getMaximumAuthenticationLifetime());
            cfg.setServiceProviderEntityId(saml.getServiceProviderEntityId());
            cfg.setServiceProviderMetadataPath(saml.getServiceProviderMetadataPath());
            cfg.setDestinationBindingType(saml.getDestinationBinding());
            cfg.setForceAuth(saml.isForceAuth());
            cfg.setPassive(saml.isPassive());
            cfg.setWantsAssertionsSigned(saml.isWantsAssertionsSigned());
            if (StringUtils.isNotBlank((CharSequence)saml.getAuthnContextClassRef())) {
                cfg.setComparisonType(saml.getAuthnContextComparisonType().toUpperCase());
                cfg.setAuthnContextClassRef(saml.getAuthnContextClassRef());
            }
            if (StringUtils.isNotBlank((CharSequence)saml.getKeystoreAlias())) {
                cfg.setKeystoreAlias(saml.getKeystoreAlias());
            }
            if (StringUtils.isNotBlank((CharSequence)saml.getNameIdPolicyFormat())) {
                cfg.setNameIdPolicyFormat(saml.getNameIdPolicyFormat());
            }
            SAML2Client client = new SAML2Client(cfg);
            int count = index.intValue();
            if (saml.getClientName() != null) {
                client.setName(saml.getClientName());
            } else if (count > 0) {
                client.setName(client.getClass().getSimpleName() + count);
            }
            index.incrementAndGet();
            LOGGER.debug("Created client [{}]", (Object)client);
            properties.add((BaseClient)client);
        });
    }

    private void configureOAuth20Client(Collection<BaseClient> properties) {
        AtomicInteger index = new AtomicInteger();
        this.casProperties.getAuthn().getPac4j().getOauth2().stream().filter(oauth -> StringUtils.isNotBlank((CharSequence)oauth.getId()) && StringUtils.isNotBlank((CharSequence)oauth.getSecret())).forEach(oauth -> {
            GenericOAuth20Client client = new GenericOAuth20Client();
            client.setKey(oauth.getId());
            client.setSecret(oauth.getSecret());
            client.setProfileAttrs(oauth.getProfileAttrs());
            client.setProfileNodePath(oauth.getProfilePath());
            client.setProfileUrl(oauth.getProfileUrl());
            client.setProfileVerb(Verb.valueOf((String)oauth.getProfileVerb().toUpperCase()));
            client.setTokenUrl(oauth.getTokenUrl());
            client.setAuthUrl(oauth.getAuthUrl());
            client.setCustomParams(oauth.getCustomParams());
            int count = index.intValue();
            if (StringUtils.isNotBlank((CharSequence)oauth.getClientName())) {
                client.setName(oauth.getClientName());
            } else if (count > 0) {
                client.setName(client.getClass().getSimpleName() + count);
            }
            index.incrementAndGet();
            LOGGER.debug("Created client [{}]", (Object)client);
            properties.add((BaseClient)client);
        });
    }

    private void configureOidcClient(Collection<BaseClient> properties) {
        AtomicInteger index = new AtomicInteger();
        this.casProperties.getAuthn().getPac4j().getOidc().stream().filter(oidc -> StringUtils.isNotBlank((CharSequence)oidc.getId()) && StringUtils.isNotBlank((CharSequence)oidc.getSecret())).forEach(oidc -> {
            GoogleOidcClient client;
            OidcConfiguration cfg = new OidcConfiguration();
            if (StringUtils.isNotBlank((CharSequence)oidc.getScope())) {
                cfg.setScope(oidc.getScope());
            }
            cfg.setUseNonce(oidc.isUseNonce());
            cfg.setSecret(oidc.getSecret());
            cfg.setClientId(oidc.getId());
            if (StringUtils.isNotBlank((CharSequence)oidc.getPreferredJwsAlgorithm())) {
                cfg.setPreferredJwsAlgorithm(JWSAlgorithm.parse((String)oidc.getPreferredJwsAlgorithm().toUpperCase()));
            }
            cfg.setMaxClockSkew(oidc.getMaxClockSkew());
            cfg.setDiscoveryURI(oidc.getDiscoveryUri());
            cfg.setCustomParams(oidc.getCustomParams());
            switch (oidc.getType().toUpperCase()) {
                case "GOOGLE": {
                    client = new GoogleOidcClient(cfg);
                    break;
                }
                case "AZURE": {
                    client = new AzureAdClient(cfg);
                    break;
                }
                case "KEYCLOAK": {
                    client = new KeycloakOidcClient(cfg);
                    break;
                }
                default: {
                    client = new OidcClient(cfg);
                }
            }
            int count = index.intValue();
            if (StringUtils.isNotBlank((CharSequence)oidc.getClientName())) {
                client.setName(oidc.getClientName());
            } else if (count > 0) {
                client.setName(client.getClass().getSimpleName() + count);
            }
            index.incrementAndGet();
            LOGGER.debug("Created client [{}]", (Object)client);
            properties.add((BaseClient)client);
        });
    }

    @RefreshScope
    @Bean
    public Clients builtClients() {
        LinkedHashSet<BaseClient> clients = new LinkedHashSet<BaseClient>();
        this.configureCasClient(clients);
        this.configureFacebookClient(clients);
        this.configureOidcClient(clients);
        this.configureOAuth20Client(clients);
        this.configureSamlClient(clients);
        this.configureTwitterClient(clients);
        this.configureDropboxClient(clients);
        this.configureFoursquareClient(clients);
        this.configureGithubClient(clients);
        this.configureGoogleClient(clients);
        this.configureWindowsLiveClient(clients);
        this.configureYahooClient(clients);
        this.configureLinkedInClient(clients);
        this.configurePaypalClient(clients);
        this.configureWordpressClient(clients);
        this.configureBitbucketClient(clients);
        this.configureOrcidClient(clients);
        LOGGER.debug("The following clients are built: [{}]", clients);
        if (clients.isEmpty()) {
            LOGGER.warn("No delegated authentication clients are defined/configured");
        }
        LOGGER.info("Located and prepared [{}] delegated authentication client(s)", (Object)clients.size());
        return new Clients(this.casProperties.getServer().getLoginUrl(), new ArrayList<BaseClient>(clients));
    }

    @ConditionalOnMissingBean(name={"clientPrincipalFactory"})
    @Bean
    public PrincipalFactory clientPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"clientAuthenticationMetaDataPopulator"})
    @Bean
    public AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator() {
        return new ClientAuthenticationMetaDataPopulator();
    }

    @ConditionalOnMissingBean(name={"saml2ClientLogoutAction"})
    @Bean
    public Action saml2ClientLogoutAction() {
        return new SAML2ClientLogoutAction(this.builtClients());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"clientAuthenticationHandler"})
    public AuthenticationHandler clientAuthenticationHandler() {
        Pac4jProperties pac4j = this.casProperties.getAuthn().getPac4j();
        ClientAuthenticationHandler h = new ClientAuthenticationHandler(pac4j.getName(), this.servicesManager, this.clientPrincipalFactory(), this.builtClients());
        h.setTypedIdUsed(pac4j.isTypedIdUsed());
        return h;
    }

    @ConditionalOnMissingBean(name={"pac4jAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer pac4jAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (!this.builtClients().findAllClients().isEmpty()) {
                LOGGER.info("Registering delegated authentication clients...");
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.clientAuthenticationHandler(), this.personDirectoryPrincipalResolver);
                plan.registerMetadataPopulator(this.clientAuthenticationMetaDataPopulator());
            }
        };
    }
}

