/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.config.support.authentication;

import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.DelegatedAuthenticationAuditResourceResolver;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.provision.ChainingDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.GroovyDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.RestfulDelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProvisioningProperties;
import org.apereo.cas.configuration.support.RestEndpointProperties;
import org.apereo.cas.integration.pac4j.DistributedJ2ESessionStore;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.LogoutPostProcessor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.pac4j.authentication.ClientAuthenticationMetaDataPopulator;
import org.apereo.cas.support.pac4j.authentication.DelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.handler.support.DelegatedClientAuthenticationHandler;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration(value="pac4jAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class Pac4jAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    @Qualifier(value="authenticationActionResolver")
    private ObjectProvider<AuditActionResolver> authenticationActionResolver;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;

    @Bean
    @ConditionalOnMissingBean(name={"pac4jDelegatedClientFactory"})
    @RefreshScope
    public DelegatedClientFactory pac4jDelegatedClientFactory() {
        return new DelegatedClientFactory(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionStore"})
    @Bean
    public SessionStore delegatedClientDistributedSessionStore() {
        return this.getDistributedSessionStore();
    }

    @RefreshScope
    @Bean
    public Clients builtClients() {
        Set clients = this.pac4jDelegatedClientFactory().build();
        LOGGER.debug("The following clients are built: [{}]", (Object)clients);
        if (clients.isEmpty()) {
            LOGGER.warn("No delegated authentication clients are defined and/or configured");
        } else {
            LOGGER.info("Located and prepared [{}] delegated authentication client(s)", (Object)clients.size());
        }
        return new Clients(this.casProperties.getServer().getLoginUrl(), new ArrayList(clients));
    }

    @ConditionalOnMissingBean(name={"clientPrincipalFactory"})
    @Bean
    public PrincipalFactory clientPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"clientAuthenticationMetaDataPopulator"})
    @Bean
    public AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator() {
        return new ClientAuthenticationMetaDataPopulator();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"clientAuthenticationHandler"})
    public AuthenticationHandler clientAuthenticationHandler() {
        Pac4jDelegatedAuthenticationProperties pac4j = this.casProperties.getAuthn().getPac4j();
        DelegatedClientAuthenticationHandler h = new DelegatedClientAuthenticationHandler(pac4j.getName(), pac4j.getOrder(), (ServicesManager)this.servicesManager.getObject(), this.clientPrincipalFactory(), this.builtClients(), this.clientUserProfileProvisioner(), this.delegatedClientDistributedSessionStore());
        h.setTypedIdUsed(pac4j.isTypedIdUsed());
        h.setPrincipalAttributeId(pac4j.getPrincipalAttributeId());
        return h;
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"clientUserProfileProvisioner"})
    public DelegatedClientUserProfileProvisioner clientUserProfileProvisioner() {
        Pac4jDelegatedAuthenticationProvisioningProperties provisioning = this.casProperties.getAuthn().getPac4j().getProvisioning();
        ChainingDelegatedClientUserProfileProvisioner chain = new ChainingDelegatedClientUserProfileProvisioner();
        Resource script = provisioning.getGroovy().getLocation();
        if (script != null) {
            chain.addProvisioner((DelegatedClientUserProfileProvisioner)new GroovyDelegatedClientUserProfileProvisioner(script));
        }
        if (StringUtils.isNotBlank((CharSequence)provisioning.getRest().getUrl())) {
            chain.addProvisioner((DelegatedClientUserProfileProvisioner)new RestfulDelegatedClientUserProfileProvisioner((RestEndpointProperties)provisioning.getRest()));
        }
        if (chain.isEmpty()) {
            return DelegatedClientUserProfileProvisioner.noOp();
        }
        return chain;
    }

    @ConditionalOnMissingBean(name={"pac4jAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer pac4jAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (!this.builtClients().findAllClients().isEmpty()) {
                LOGGER.info("Registering delegated authentication clients...");
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.clientAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
                plan.registerAuthenticationMetadataPopulator(this.clientAuthenticationMetaDataPopulator());
            }
        };
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditResourceResolver"})
    @Bean
    public AuditResourceResolver delegatedAuthenticationAuditResourceResolver() {
        return new DelegatedAuthenticationAuditResourceResolver();
    }

    @Bean
    public AuditTrailRecordResolutionPlanConfigurer delegatedAuthenticationAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditActionResolver("DELEGATED_CLIENT_ACTION_RESOLVER", (AuditActionResolver)this.authenticationActionResolver.getObject());
            plan.registerAuditResourceResolver("DELEGATED_CLIENT_RESOURCE_RESOLVER", this.delegatedAuthenticationAuditResourceResolver());
        };
    }

    @Bean
    public LogoutExecutionPlanConfigurer delegatedAuthenticationLogoutExecutionPlanConfigurer() {
        return plan -> plan.registerLogoutPostProcessor((LogoutPostProcessor)this.getDistributedSessionStore());
    }

    private DistributedJ2ESessionStore getDistributedSessionStore() {
        return new DistributedJ2ESessionStore((TicketRegistry)this.ticketRegistry.getObject(), (TicketFactory)this.ticketFactory.getObject(), this.casProperties);
    }
}

