/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication;

import java.util.ArrayList;
import java.util.Map;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.token.TokenAuthenticationProperties;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;

public class OAuth20AccessTokenAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private final ConfigurableApplicationContext applicationContext;

    public OAuth20AccessTokenAuthenticationHandler(PrincipalFactory principalFactory, ConfigurableApplicationContext applicationContext, TokenAuthenticationProperties properties) {
        super("", principalFactory, Integer.valueOf(properties.getOrder() - 1));
        this.applicationContext = applicationContext;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws PreventedException {
        try {
            OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.applicationContext.getBean("oauth20ConfigurationContext", OAuth20ConfigurationContext.class);
            BasicIdentifiableCredential tokenCredential = (BasicIdentifiableCredential)credential;
            String accessTokenId = (String)OAuth20JwtAccessTokenEncoder.toDecodableCipher((JwtBuilder)configurationContext.getAccessTokenJwtBuilder()).decode((Object)tokenCredential.getId());
            OAuth20AccessToken decodedToken = (OAuth20AccessToken)configurationContext.getTicketRegistry().getTicket(accessTokenId, OAuth20AccessToken.class);
            Assert.isTrue((decodedToken != null && !decodedToken.isExpired() ? 1 : 0) != 0, (String)"Access token is invalid or expired");
            Map claims = configurationContext.getUserProfileDataCreator().createFrom(decodedToken);
            Map attributes = CollectionUtils.toMultiValuedMap((Map)((Map)claims.get("attributes")));
            String principalId = decodedToken.getAuthentication().getPrincipal().getId();
            Principal principal = this.principalFactory.createPrincipal(principalId, attributes);
            tokenCredential.setId(principal.getId());
            return this.createHandlerResult((Credential)tokenCredential, principal, new ArrayList());
        }
        catch (Throwable e) {
            throw new AuthenticationException(e);
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof BasicIdentifiableCredential;
    }
}

