/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication;

import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.authentication.TokenAuthenticationSecurity;
import org.apereo.cas.util.function.FunctionUtils;

public class TokenAuthenticationPostProcessor
implements AuthenticationPostProcessor {
    private final ServicesManager servicesManager;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    public void process(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        FunctionUtils.doIfNotNull((Object)transaction.getService(), service -> {
            Authentication authentication = builder.build();
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService(registeredService).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
            String token = TokenAuthenticationSecurity.forRegisteredService(registeredService).generateTokenFor(authentication);
            builder.addAttribute("token", (Object)token);
        });
    }

    public boolean supports(Credential credential) {
        return credential != null;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Generated
    public TokenAuthenticationPostProcessor(ServicesManager servicesManager, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.servicesManager = servicesManager;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

