/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.authentication.TokenCredential;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.TokenRequestExtractor;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class TokenAuthenticationAction
extends AbstractNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationAction.class);
    private final TokenRequestExtractor tokenRequestExtractor;
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final CasConfigurationProperties casProperties;
    private final AuthenticationServiceSelectionPlan serviceSelectionStrategy;

    public TokenAuthenticationAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, TokenRequestExtractor tokenRequestExtractor, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CasConfigurationProperties casProperties) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.tokenRequestExtractor = tokenRequestExtractor;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
        this.casProperties = casProperties;
    }

    protected Credential constructCredentialsFromRequest(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Service service = this.resolveServiceFromRequest(requestContext);
        return Optional.ofNullable(this.tokenRequestExtractor.extract(request)).or(() -> {
            Object tokenValue = service.getAttributes().get("token");
            return CollectionUtils.firstElement(tokenValue).map(Object::toString);
        }).filter(StringUtils::isNotBlank).map(authTokenValue -> {
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            TokenCredential credential = new TokenCredential(authTokenValue, service);
            LOGGER.debug("Received token authentication request [{}] ", (Object)credential);
            return credential;
        }).orElse(null);
    }

    protected Service resolveServiceFromRequest(RequestContext requestContext) {
        return (Service)FunctionUtils.doUnchecked(() -> {
            WebApplicationService givenService = Optional.ofNullable(WebUtils.getService((RequestContext)requestContext)).orElseGet(() -> (WebApplicationService)this.webApplicationServiceFactory.createService(this.casProperties.getServer().getPrefix()));
            return this.serviceSelectionStrategy.resolveService((Service)givenService);
        });
    }
}

