/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;

class Invokable {
    private final Class<?> classType;

    Invokable(ClassLoader cl, String className) {
        this.classType = Invokable.loadClass(cl, className);
    }

    Invokable(ClassLoader cl, Class<?> classType) {
        this.classType = Invokable.reloadClass(cl, classType);
    }

    static Class<?> loadClass(ClassLoader cl, String classTypeName) throws InvocationException {
        try {
            return cl.loadClass(classTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new InvocationException(e, "Unable to load class {0} with class loader {1}", classTypeName, cl);
        }
    }

    static Class<?> reloadClass(ClassLoader cl, Class<?> classType) throws InvocationException {
        try {
            return cl.loadClass(classType.getName());
        }
        catch (ClassNotFoundException e) {
            throw new InvocationException(e, "Unable to reload class {0} with class loader {1}, previously loaded with {2}", classType.getName(), cl, classType.getClassLoader());
        }
    }

    Object invokeMethod(String name, Class<?>[] parameterTypes, Object instance, Object[] parameters) throws InvocationException {
        try {
            return this.findMethod(name, parameterTypes).invoke(instance, parameters);
        }
        catch (IllegalAccessException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters);
        }
        catch (InvocationTargetException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters);
        }
        catch (SecurityException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters);
        }
        catch (InvocationException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters);
        }
    }

    Object invokeConstructor(Class<?>[] parameterTypes, Object[] parameters) throws InvocationException {
        try {
            Constructor<?> con = this.classType.getConstructor(parameterTypes);
            return con.newInstance(parameters);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {2}", this.classType.getSimpleName(), parameterTypes, parameters);
        }
        catch (SecurityException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {2}", this.classType.getSimpleName(), parameterTypes, parameters);
        }
        catch (InstantiationException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {2}", this.classType.getSimpleName(), parameterTypes, parameters);
        }
        catch (IllegalAccessException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {2}", this.classType.getSimpleName(), parameterTypes, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {2}", this.classType.getSimpleName(), parameterTypes, parameters);
        }
        catch (InvocationTargetException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {2}", this.classType.getSimpleName(), parameterTypes, parameters);
        }
    }

    private Method findMethod(String name, Class<?>[] parameterTypes) throws SecurityException, InvocationException {
        Method m = null;
        try {
            m = this.classType.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Class<?> iterator = this.classType.getSuperclass(); iterator != null; iterator = iterator.getSuperclass()) {
                try {
                    m = iterator.getDeclaredMethod(name, parameterTypes);
                    m.setAccessible(true);
                    return m;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            throw new InvocationException("Unable to find method {0}({1}) in class {2} nor its superclasses or implemented interfaces", name, parameterTypes, this.classType.getName());
        }
    }

    static class InvocationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InvocationException(Throwable e) {
            super(e);
        }

        InvocationException(Throwable e, String pattern, Object ... args) {
            super(MessageFormat.format(pattern, args), e);
        }

        InvocationException(String pattern, Object ... args) {
            super(MessageFormat.format(pattern, args));
        }
    }
}

