/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.process;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.arquillian.spacelift.process.OutputTransformer;
import org.arquillian.spacelift.process.ProcessInteraction;
import org.arquillian.spacelift.process.Sentence;

public class ProcessInteractionBuilder {
    public static final ProcessInteraction NO_INTERACTION = new ProcessInteractionBuilder().build();
    private String textTypedIn;
    private Map<Pattern, String> replyMap = new LinkedHashMap<Pattern, String>();
    private List<Pattern> allowedOutput = new ArrayList<Pattern>();
    private List<Pattern> errorOutput = new ArrayList<Pattern>();
    private List<Pattern> terminatingOutput = new ArrayList<Pattern>();
    private OutputTransformer transformer = null;
    private Pattern lastPattern;

    public MatchedOutputProcessInteractionBuilder when(String pattern) {
        this.lastPattern = Pattern.compile(pattern);
        return new MatchedOutputProcessInteractionBuilder();
    }

    public StartingProcessInteractionBuilder whenStarts() {
        return new StartingProcessInteractionBuilder();
    }

    public ProcessInteractionBuilder outputPrefix(final String prefix) {
        this.transformer = prefix == null || "".equals(prefix) ? new OutputTransformer(){

            @Override
            public Sentence transform(Sentence output) {
                return output;
            }
        } : new OutputTransformer(){

            @Override
            public Sentence transform(Sentence output) {
                return output.prepend(prefix);
            }
        };
        return this;
    }

    public ProcessInteraction build() {
        return new ProcessInteractionImpl(this.replyMap, this.transformer, this.allowedOutput, this.errorOutput, this.terminatingOutput, this.textTypedIn);
    }

    public class MatchedOutputProcessInteractionBuilder {
        public ProcessInteractionBuilder replyWith(String response) {
            ProcessInteractionBuilder.this.replyMap.put(ProcessInteractionBuilder.this.lastPattern, response);
            return ProcessInteractionBuilder.this;
        }

        public ProcessInteractionBuilder terminate() {
            ProcessInteractionBuilder.this.terminatingOutput.add(ProcessInteractionBuilder.this.lastPattern);
            return ProcessInteractionBuilder.this;
        }

        public ProcessInteractionBuilder printToOut() {
            ProcessInteractionBuilder.this.allowedOutput.add(ProcessInteractionBuilder.this.lastPattern);
            return ProcessInteractionBuilder.this;
        }

        public ProcessInteractionBuilder printToErr() {
            ProcessInteractionBuilder.this.errorOutput.add(ProcessInteractionBuilder.this.lastPattern);
            return ProcessInteractionBuilder.this;
        }
    }

    public class StartingProcessInteractionBuilder {
        public ProcessInteractionBuilder typeIn(String sentence) {
            ProcessInteractionBuilder.this.textTypedIn = sentence;
            return ProcessInteractionBuilder.this;
        }
    }

    private static class ProcessInteractionImpl
    implements ProcessInteraction {
        private final String textTypedIn;
        private final Map<Pattern, String> replyMap;
        private final List<Pattern> allowedOutput;
        private final List<Pattern> errorOutput;
        private final List<Pattern> terminatingOutput;
        private final OutputTransformer transformer;

        public ProcessInteractionImpl(Map<Pattern, String> replyMap, OutputTransformer outputTransformer, List<Pattern> allowedOutput, List<Pattern> errorOutput, List<Pattern> terminatingOutput, String textTypedIn) {
            this.replyMap = replyMap;
            this.transformer = outputTransformer;
            this.allowedOutput = allowedOutput;
            this.errorOutput = errorOutput;
            this.terminatingOutput = terminatingOutput;
            this.textTypedIn = textTypedIn;
        }

        @Override
        public List<Pattern> allowedOutput() {
            return this.allowedOutput;
        }

        @Override
        public List<Pattern> errorOutput() {
            return this.errorOutput;
        }

        @Override
        public Map<Pattern, String> replyMap() {
            return this.replyMap;
        }

        @Override
        public List<Pattern> terminatingOutput() {
            return this.terminatingOutput;
        }

        @Override
        public String textTypedIn() {
            return this.textTypedIn;
        }

        @Override
        public OutputTransformer transformer() {
            return this.transformer;
        }
    }
}

