/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.cloudevent;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.v1.CloudEventBuilder;
import java.net.URI;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.kafka.eventhandling.cloudevent.InvalidMetaDataException;
import org.axonframework.extensions.kafka.eventhandling.cloudevent.MetadataUtils;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionUtils.class);
    public static final String MESSAGE_REVISION = "axonmessagerevision";
    public static final String AGGREGATE_ID = "axonmessageaggregateid";
    public static final String AGGREGATE_SEQ = "axonmessageaggregateseq";
    public static final String AGGREGATE_TYPE = "axonmessageaggregatetype";
    private static final Set<String> NON_METADATA_EXTENSIONS = Stream.of("axonmessageaggregatetype", "axonmessageaggregateid", "axonmessageaggregateseq", "axonmessagerevision").collect(Collectors.toCollection(HashSet::new));

    private ExtensionUtils() {
    }

    public static void setExtensions(CloudEventBuilder builder, EventMessage<?> message, SerializedObject<byte[]> serializedObject, Map<String, String> extensionNameResolver, boolean ignoreInvalidExtensionNames) {
        if (!Objects.isNull(serializedObject.getType().getRevision())) {
            builder.withExtension(MESSAGE_REVISION, serializedObject.getType().getRevision());
        }
        if (message instanceof DomainEventMessage) {
            DomainEventMessage domainMessage = (DomainEventMessage)message;
            builder.withExtension(AGGREGATE_ID, domainMessage.getAggregateIdentifier());
            builder.withExtension(AGGREGATE_SEQ, (Number)domainMessage.getSequenceNumber());
            builder.withExtension(AGGREGATE_TYPE, domainMessage.getType());
        }
        message.getMetaData().entrySet().stream().filter(MetadataUtils.reservedMetadataFilter()).forEach(entry -> ExtensionUtils.setExtension(builder, ExtensionUtils.resolveExtensionName((String)entry.getKey(), extensionNameResolver), entry.getValue(), ignoreInvalidExtensionNames));
    }

    public static MetaData getExtensionsAsMetadata(CloudEvent cloudEvent, Map<String, String> metadataNameResolver) {
        HashMap metadataMap = new HashMap();
        cloudEvent.getExtensionNames().forEach(name -> {
            if (!ExtensionUtils.isNonMetadataExtension(name)) {
                metadataMap.put(ExtensionUtils.resolveMetadataKey(name, metadataNameResolver), cloudEvent.getExtension(name));
            }
        });
        return MetaData.from(metadataMap);
    }

    private static String resolveMetadataKey(String extensionName, Map<String, String> metadataNameResolver) {
        if (metadataNameResolver.containsKey(extensionName)) {
            return metadataNameResolver.get(extensionName);
        }
        logger.debug("Extension name: '{}' was not part of the supplied map, this might give errors", (Object)extensionName);
        return extensionName;
    }

    private static String resolveExtensionName(String metadataKey, Map<String, String> extensionNameResolver) {
        if (extensionNameResolver.containsKey(metadataKey)) {
            return extensionNameResolver.get(metadataKey);
        }
        logger.debug("Metadata key: '{}' was not part of the supplied map, this might give errors", (Object)metadataKey);
        return metadataKey;
    }

    private static boolean isNonMetadataExtension(String extensionName) {
        return NON_METADATA_EXTENSIONS.contains(extensionName);
    }

    private static void setExtension(CloudEventBuilder builder, String extensionName, Object value, boolean ignoreInvalidExtensionNames) {
        if (ExtensionUtils.isNonMetadataExtension(extensionName)) {
            throw new InvalidMetaDataException(String.format("Metadata property '%s' is already reserved to be used for Axon", extensionName));
        }
        if (!ExtensionUtils.isValidExtensionName(extensionName)) {
            if (ignoreInvalidExtensionNames) {
                logger.warn("Metadata property: '{}' is not a valid extension name and will be ignored", (Object)extensionName);
                return;
            }
            throw new InvalidMetaDataException(String.format("Metadata property '%s' is not a valid extension name", extensionName));
        }
        if (value instanceof String) {
            builder.withExtension(extensionName, (String)value);
        } else if (value instanceof Number) {
            builder.withExtension(extensionName, (Number)value);
        } else if (value instanceof Boolean) {
            builder.withExtension(extensionName, (Boolean)value);
        } else if (value instanceof URI) {
            builder.withExtension(extensionName, (URI)value);
        } else if (value instanceof OffsetDateTime) {
            builder.withExtension(extensionName, (OffsetDateTime)value);
        } else if (value instanceof byte[]) {
            builder.withExtension(extensionName, (byte[])value);
        } else {
            throw new InvalidMetaDataException(String.format("Metadata property '%s' is of class '%s' and thus can't be added.\nSupported classes are String, Number, Boolean, URI, OffsetDataTime and byte[]", extensionName, value.getClass()));
        }
    }

    public static String asNullableString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static Long asLong(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    public static OffsetDateTime asOffsetDateTime(Object object, long fallbackTimestamp) {
        if (object instanceof OffsetDateTime) {
            return (OffsetDateTime)object;
        }
        return Instant.ofEpochMilli(fallbackTimestamp).atOffset(ZoneOffset.UTC);
    }

    public static byte[] asBytes(CloudEventData data) {
        if (Objects.isNull(data)) {
            return new byte[0];
        }
        return data.toBytes();
    }

    public static boolean isValidExtensionName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (ExtensionUtils.isValidChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public static boolean isValidMetadataToExtensionMap(Map<String, String> metadataToExtensionMap) {
        for (String extensionName : metadataToExtensionMap.values()) {
            if (ExtensionUtils.isValidExtensionName(extensionName)) continue;
            return false;
        }
        return true;
    }
}

