/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.kafka.eventhandling.consumer.ConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumerFactory<K, V>
implements ConsumerFactory<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConsumerFactory.class);
    private final Map<String, Object> consumerConfiguration;

    public DefaultConsumerFactory(Map<String, Object> consumerConfiguration) {
        BuilderUtils.assertNonNull(consumerConfiguration, (String)"The configuration may not be null");
        this.consumerConfiguration = new HashMap<String, Object>(consumerConfiguration);
    }

    @Override
    public Consumer<K, V> createConsumer(String groupId) {
        HashMap<String, Object> configuration = new HashMap<String, Object>(this.consumerConfiguration);
        if (configuration.remove("group.id") != null) {
            logger.warn("Found a global {} whilst it is required to be provided consciously", (Object)"group.id");
        }
        if (groupId != null) {
            configuration.put("group.id", groupId);
        }
        return new KafkaConsumer(configuration);
    }

    public Map<String, Object> configurationProperties() {
        return Collections.unmodifiableMap(this.consumerConfiguration);
    }
}

