/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.axonframework.common.Assert;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.extensions.kafka.eventhandling.consumer.EventConsumer;
import org.axonframework.extensions.kafka.eventhandling.consumer.FetchEventException;
import org.axonframework.extensions.kafka.eventhandling.consumer.OffsetCommitType;
import org.axonframework.extensions.kafka.eventhandling.consumer.RecordConverter;
import org.axonframework.extensions.kafka.eventhandling.consumer.RuntimeErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FetchEventsTask<K, V, E>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Consumer<K, V> consumer;
    private final Duration pollTimeout;
    private final RecordConverter<K, V, E> recordConverter;
    private final EventConsumer<E> eventConsumer;
    private final java.util.function.Consumer<FetchEventsTask<K, V, E>> closeHandler;
    private final RuntimeErrorHandler runtimeErrorHandler;
    private final OffsetCommitType offsetCommitType;

    FetchEventsTask(Consumer<K, V> consumer, Duration pollTimeout, RecordConverter<K, V, E> recordConverter, EventConsumer<E> eventConsumer, java.util.function.Consumer<FetchEventsTask<K, V, E>> closeHandler, RuntimeErrorHandler runtimeErrorHandler, OffsetCommitType offsetCommitType) {
        this.consumer = (Consumer)Assert.nonNull(consumer, () -> "Consumer may not be null");
        BuilderUtils.assertThat((Object)pollTimeout, time -> !time.isNegative(), (String)("The poll timeout may not be negative [" + pollTimeout + "]"));
        this.pollTimeout = pollTimeout;
        this.recordConverter = recordConverter;
        this.eventConsumer = eventConsumer;
        this.closeHandler = (java.util.function.Consumer)ObjectUtils.getOrDefault(closeHandler, task -> {});
        this.runtimeErrorHandler = (RuntimeErrorHandler)Assert.nonNull((Object)runtimeErrorHandler, () -> "Runtime error handler may not be null");
        this.offsetCommitType = offsetCommitType;
    }

    @Override
    public void run() {
        try {
            while (this.running.get()) {
                ConsumerRecords records = this.consumer.poll(this.pollTimeout);
                logger.debug("Fetched [{}] number of ConsumerRecords", (Object)records.count());
                this.processRecords(records);
            }
        }
        catch (Exception e) {
            logger.warn("Encountered an exception fetching ConsumerRecords", (Throwable)e);
            this.runtimeErrorHandler.handle((RuntimeException)((Object)new FetchEventException("Cannot proceed with fetching ConsumerRecords since we encountered an exception", e)));
        }
        finally {
            this.running.set(false);
            this.closeHandler.accept(this);
            this.consumer.close();
            logger.info("Fetch events task and used Consumer instance [{}] have been closed", this.consumer);
        }
    }

    private void processRecords(ConsumerRecords<K, V> records) {
        List<E> convertedMessages = this.recordConverter.convert(records);
        try {
            if (!convertedMessages.isEmpty()) {
                this.eventConsumer.consume(convertedMessages);
                this.handleOffsetsIfRequired(convertedMessages.size());
            }
        }
        catch (InterruptedException e) {
            logger.debug("Event Consumer thread was interrupted. Shutting down", (Throwable)e);
            this.running.set(false);
            Thread.currentThread().interrupt();
        }
    }

    private void handleOffsetsIfRequired(int messageCount) {
        if (OffsetCommitType.COMMIT_SYNC == this.offsetCommitType) {
            this.consumer.commitSync();
            logger.debug("Committed offsets synchronously for {} messages", (Object)messageCount);
        } else if (OffsetCommitType.COMMIT_ASYNC == this.offsetCommitType) {
            this.consumer.commitAsync();
            logger.debug("Committed offsets asynchronously for {} messages", (Object)messageCount);
        } else {
            logger.debug("Consumer will commit offsets in background");
        }
    }

    public void close() {
        logger.info("Closing down FetchEventsTask using Consumer [{}]", this.consumer);
        this.running.set(false);
    }
}

