/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer.streamable;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventStream;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.Buffer;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.KafkaEventMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessageStream
implements TrackingEventStream {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageStream.class);
    private final Buffer<KafkaEventMessage> buffer;
    private final Registration closeHandler;
    private KafkaEventMessage peekedEvent;

    public KafkaMessageStream(Buffer<KafkaEventMessage> buffer, Registration closeHandler) {
        BuilderUtils.assertNonNull(buffer, (String)"Buffer may not be null");
        this.buffer = buffer;
        this.closeHandler = closeHandler;
    }

    public Optional<TrackedEventMessage<?>> peek() {
        return Optional.ofNullable(this.peekedEvent == null && !this.hasNextAvailable(0, TimeUnit.NANOSECONDS) ? null : this.peekedEvent.value());
    }

    public boolean hasNextAvailable(int timeout, TimeUnit unit) {
        try {
            return this.peekedEvent != null || (this.peekedEvent = this.buffer.poll(timeout, unit)) != null;
        }
        catch (InterruptedException e) {
            logger.warn("Consumer thread was interrupted. Returning thread to event processor.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public TrackedEventMessage<?> nextAvailable() {
        try {
            TrackedEventMessage<?> trackedEventMessage = this.peekedEvent == null ? this.buffer.take().value() : this.peekedEvent.value();
            return trackedEventMessage;
        }
        catch (InterruptedException e) {
            logger.warn("Consumer thread was interrupted. Returning thread to event processor.", (Throwable)e);
            Thread.currentThread().interrupt();
            TrackedEventMessage<?> trackedEventMessage = null;
            return trackedEventMessage;
        }
        finally {
            this.peekedEvent = null;
        }
    }

    public void close() {
        if (this.closeHandler != null) {
            this.closeHandler.close();
        }
    }
}

