/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer.streamable;

import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.axonframework.common.Assert;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.Buffer;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.KafkaRecordMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedKafkaMessageBuffer<E extends Comparable<?> & KafkaRecordMetaData<?>>
implements Buffer<E> {
    private static final Logger logger = LoggerFactory.getLogger(SortedKafkaMessageBuffer.class);
    private static final int DEFAULT_CAPACITY = 1000;
    private final ConcurrentSkipListSet<E> delegate;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private final int capacity;
    private int count;
    private final AtomicReference<RuntimeException> possibleException = new AtomicReference<Object>(null);

    public SortedKafkaMessageBuffer() {
        this(1000);
    }

    public SortedKafkaMessageBuffer(int capacity) {
        Assert.isTrue((capacity > 0 ? 1 : 0) != 0, () -> "The given capacity [" + capacity + "] may not be smaller than 0");
        this.delegate = new ConcurrentSkipListSet();
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.capacity = capacity;
    }

    @Override
    public void put(E e) throws InterruptedException {
        Assert.notNull(e, () -> "Element may not be null");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            this.doPut(e);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Collection<E> c) throws InterruptedException {
        Assert.notNull(c, () -> "Element collection may not be null");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            for (Comparable e : c) {
                this.doPut(e);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void doPut(E e) throws InterruptedException {
        while (this.count == this.capacity) {
            this.notFull.await();
        }
        this.add(e);
        if (logger.isDebugEnabled()) {
            logger.debug("Buffer state after appending element [{}]", e);
            for (Comparable message : this.delegate) {
                logger.debug("Partition:{}, Offset:{}, Timestamp:{}, Payload:{}", new Object[]{((KafkaRecordMetaData)((Object)message)).partition(), ((KafkaRecordMetaData)((Object)message)).offset(), ((KafkaRecordMetaData)((Object)message)).timestamp(), ((KafkaRecordMetaData)((Object)message)).value()});
            }
        }
    }

    private void add(E x) {
        if (this.delegate.add(x)) {
            ++this.count;
            this.notEmpty.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.throwIfPresent();
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E removed = this.remove();
            if (logger.isDebugEnabled()) {
                logger.debug("Buffer state after removing element [{}]", removed);
                for (Comparable message : this.delegate) {
                    logger.debug("Partition:{}, Offset:{}, Timestamp:{}, Payload:{}", new Object[]{((KafkaRecordMetaData)((Object)message)).partition(), ((KafkaRecordMetaData)((Object)message)).offset(), ((KafkaRecordMetaData)((Object)message)).value(), ((KafkaRecordMetaData)((Object)message)).timestamp()});
                }
            }
            E e = removed;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.throwIfPresent();
                this.notEmpty.await();
            }
            E e = this.remove();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private E remove() {
        Comparable x = (Comparable)this.delegate.pollFirst();
        if (x != null) {
            --this.count;
            this.notFull.signal();
        }
        return (E)x;
    }

    @Override
    public E peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (this.count > 0) {
                Comparable comparable = (Comparable)this.delegate.first();
                return (E)comparable;
            }
            this.throwIfPresent();
            E e = null;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.count == 0;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void throwIfPresent() {
        RuntimeException e = this.possibleException.get();
        if (e != null) {
            throw e;
        }
    }

    public String toString() {
        return "SortedKafkaMessageBuffer:" + this.delegate;
    }

    @Override
    public void setException(RuntimeException exception) {
        this.possibleException.set(exception);
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

