/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.model.Site;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceSiteMojo;

@Mojo(name="delete", threadSafe=true, requiresProject=false)
public class ConfluenceDeleteMojo
extends AbstractBaseConfluenceSiteMojo {
    @Parameter(property="recursive", defaultValue="true")
    private boolean recursive;

    private String getStartPageTitle() {
        String result;
        if (this.isSiteDescriptorValid()) {
            Site site = this.createSiteFromModel();
            result = site.getHome().getName();
        } else {
            result = this.getPageTitle();
        }
        return result;
    }

    private void deletePage(ConfluenceService confluence) throws Exception {
        ConfluenceService.Model.Page parentPage = this.loadParentPage(confluence, Optional.empty());
        if (parentPage == null) {
            this.getLog().warn((CharSequence)"Parent page not found!");
            return;
        }
        String startPageTitle = this.getStartPageTitle();
        this.getLog().debug((CharSequence)String.format("start deleting from page [%s]", startPageTitle));
        ConfluenceService.Model.PageSummary start = confluence.findPageByTitle(parentPage.getId(), startPageTitle);
        if (start == null) {
            this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] not found!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
            return;
        }
        if (this.recursive) {
            List descendents = confluence.getDescendents(start.getId());
            if (descendents == null || descendents.isEmpty()) {
                this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not descendents!", parentPage.getTitle(), this.getPageTitle(), parentPage.getSpace()));
            } else {
                for (ConfluenceService.Model.PageSummary descendent : descendents) {
                    this.getLog().info((CharSequence)String.format("Page [%s]/[%s]/[%s]  has been removed!", parentPage.getTitle(), this.getPageTitle(), descendent.getTitle()));
                    confluence.removePageAsync(descendent.getId()).join();
                }
            }
        }
        confluence.removePageAsync(start.getId()).join();
        this.getLog().info((CharSequence)String.format("Page [%s]/[%s] in [%s] has been removed!", parentPage.getTitle(), this.getPageTitle(), parentPage.getSpace()));
    }

    void tryDeletePage(ConfluenceService confluence) {
        try {
            this.deletePage(confluence);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.loadUserInfoFromSettings();
        super.confluenceExecute(this::tryDeletePage);
    }
}

