/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class PackFile
implements Serializable {
    static final long serialVersionUID = -834377078706854909L;
    public transient String sourcePath = null;
    protected String relativePath = null;
    private String targetPath = null;
    private List<OsModel> osConstraints = null;
    private long length = 0L;
    private transient long size = 0L;
    private long mtime = -1L;
    private boolean isDirectory = false;
    private OverrideType override;
    private String overrideRenameTo;
    private Blockable blockable = Blockable.BLOCKABLE_NONE;
    private Map additionals = null;
    public String previousPackId = null;
    public long offsetInPreviousPack = -1L;
    private boolean pack200Jar = false;
    private String condition = null;

    public PackFile(File baseDir, File src, String target, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable) throws IOException {
        this(src, FileUtil.getRelativeFileName((File)src, (File)baseDir), target, osList, override, overrideRenameTo, blockable, null);
    }

    public PackFile(File src, String relativeSourcePath, String target, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, Map additionals) throws FileNotFoundException {
        if (!src.exists()) {
            throw new FileNotFoundException("No such file: " + src);
        }
        if ('/' != File.separatorChar) {
            target = target.replace(File.separatorChar, '/');
        }
        if (target.endsWith("/")) {
            target = target.substring(0, target.length() - 1);
        }
        this.sourcePath = src.getPath().replace(File.separatorChar, '/');
        this.relativePath = relativeSourcePath != null ? relativeSourcePath.replace(File.separatorChar, '/') : relativeSourcePath;
        this.targetPath = target != null ? target.replace(File.separatorChar, '/') : target;
        this.osConstraints = osList;
        this.override = override;
        this.overrideRenameTo = overrideRenameTo;
        this.blockable = blockable;
        this.size = this.length = src.length();
        this.mtime = src.lastModified();
        this.isDirectory = src.isDirectory();
        this.additionals = additionals;
        if (this.isDirectory) {
            this.length = 0L;
        }
    }

    public PackFile(File baseDir, File src, String target, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, Map additionals) throws IOException {
        this(src, FileUtil.getRelativeFileName((File)src, (File)baseDir), target, osList, override, overrideRenameTo, blockable, additionals);
    }

    public void setPreviousPackFileRef(String previousPackId, Long offsetInPreviousPack) {
        this.previousPackId = previousPackId;
        this.offsetInPreviousPack = offsetInPreviousPack;
    }

    public final List<OsModel> osConstraints() {
        return this.osConstraints;
    }

    public final long length() {
        return this.length;
    }

    public final long size() {
        return this.size;
    }

    public final long lastModified() {
        return this.mtime;
    }

    public final OverrideType override() {
        return this.override;
    }

    public final String overrideRenameTo() {
        return this.overrideRenameTo;
    }

    public final Blockable blockable() {
        return this.blockable;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final boolean isBackReference() {
        return this.previousPackId != null;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    public String getRelativeSourcePath() {
        return this.relativePath;
    }

    public Map getAdditionals() {
        return this.additionals;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public boolean isPack200Jar() {
        return this.pack200Jar;
    }

    public void setPack200Jar(boolean pack200Jar) {
        this.pack200Jar = pack200Jar;
    }

    public void setLoosePackInfo(boolean loose) {
        if (loose) {
            this.length = 0L;
        }
    }
}

