/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.XRefPackageBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.comparator.DescAfferentCouplingPackageComparator;

public class JDependReportBean
extends AbstractReportBean {
    private double averageAfferentCoupling = 0.0;
    private int nbPackages = 0;
    private int sumAC = 0;
    private List packages = new ArrayList();

    public JDependReportBean() {
    }

    public JDependReportBean(Date dateGeneration) {
        super(dateGeneration);
    }

    public int getNbPackages() {
        return this.nbPackages;
    }

    public void setNbPackages(int nbPackages) {
        this.nbPackages = nbPackages;
    }

    public int getSumAC() {
        return this.sumAC;
    }

    public void setSumAC(int sumAC) {
        this.sumAC = sumAC;
    }

    public double getAverageAfferentCoupling() {
        return this.averageAfferentCoupling;
    }

    public void setAverageAfferentCoupling(double averageAfferentCoupling) {
        this.averageAfferentCoupling = averageAfferentCoupling;
    }

    public void merge(IDashBoardReportBean dashboardReport) {
        if (dashboardReport != null && dashboardReport instanceof JDependReportBean) {
            this.sumAC += ((JDependReportBean)dashboardReport).getSumAC();
            this.nbPackages += ((JDependReportBean)dashboardReport).getNbPackages();
            this.averageAfferentCoupling = this.nbPackages == 0 ? 0.0 : (double)this.sumAC / (double)this.nbPackages;
            this.packages.addAll(((JDependReportBean)dashboardReport).getPackages());
        }
    }

    public List getPackages() {
        Collections.sort(this.packages, new DescAfferentCouplingPackageComparator());
        return this.packages;
    }

    public void setPackages(List packages) {
        this.packages = packages;
    }

    public void addPackage(XRefPackageBean pack) {
        this.packages.add(pack);
        this.sumAC += pack.getAfferentCoupling().intValue();
        ++this.nbPackages;
        this.averageAfferentCoupling = this.nbPackages == 0 ? 0.0 : (double)this.sumAC / (double)this.nbPackages;
    }
}

