/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ship;

import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.mojo.ship.ScriptEngine;
import org.codehaus.mojo.ship.ScriptException;

public class BeanShellScriptEngine
implements ScriptEngine {
    public String getExtension() {
        return "bsh";
    }

    public Object eval(String script, Map globalVariables) throws ScriptException {
        Interpreter engine = new Interpreter();
        if (!Capabilities.haveAccessibility()) {
            try {
                Capabilities.setAccessibility((boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (globalVariables != null) {
            Iterator it = globalVariables.keySet().iterator();
            while (it.hasNext()) {
                String variable = (String)it.next();
                Object value = globalVariables.get(variable);
                try {
                    engine.set(variable, value);
                }
                catch (EvalError e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            return engine.eval(script);
        }
        catch (TargetError e) {
            throw new ScriptException(e.getTarget());
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ScriptException(e);
        }
    }
}

