/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ship;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.ship.ScriptEngineManager;
import org.codehaus.mojo.ship.Selector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public class ShipMojo
extends AbstractMojo {
    private ArtifactFactory factory;
    private ArtifactResolver resolver;
    private ArtifactRepository local;
    private WagonManager wagonManager;
    private Settings settings;
    protected List remoteRepos;
    private MavenProject project;
    private ArtifactFactory artifactFactory;
    private String shipVersion;
    private boolean shipSnapshotsAllowed;
    private boolean shipSnapshotsSkipped;
    private boolean shipSkip;
    private Selector[] selectors;
    private String shipScriptDirectory;
    private String shipScript;
    private String[] shipScripts;
    private String encoding;
    private List pluginDependencies;
    private boolean alwaysUsePluginDependencies;
    private boolean failOnMissingScripts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean searchReactor;
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
        if (this.shipSkip) {
            this.getLog().info((CharSequence)"Shipping skipped.");
            return;
        }
        if (this.shipScript != null) {
            this.getLog().debug((CharSequence)"A single ship script has been specified via the shipScript configuration option");
            this.shipScripts = new String[]{this.shipScript};
        } else if (this.shipScripts == null || this.shipScripts.length == 0) {
            this.getLog().debug((CharSequence)"Using default ship script selector of '*'");
            this.shipScripts = new String[]{"*"};
        }
        this.getLog().info((CharSequence)("Ship version: " + this.shipVersion));
        if (ArtifactUtils.isSnapshot((String)this.shipVersion)) {
            if (this.shipSnapshotsSkipped) {
                this.getLog().info((CharSequence)"Shipping skipped as ship version is a -SNAPSHOT");
                return;
            }
            if (!this.shipSnapshotsAllowed) {
                throw new MojoExecutionException("Shipping -SNAPSHOT version is not allowed and the requested shipVersion (" + this.shipVersion + ") is a -SNAPSHOT");
            }
        }
        if (searchReactor = StringUtils.equals((String)this.shipVersion, (String)this.project.getVersion())) {
            this.getLog().debug((CharSequence)"Ship version is project version, will preferentially resolve from the reactor");
        }
        if (this.selectors == null) {
            this.selectors = "pom".equals(this.project.getPackaging()) ? new Selector[]{new Selector(this.project.getPackaging())} : new Selector[]{new Selector("pom"), new Selector(this.project.getPackaging())};
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.addAll(this.project.getArtifacts());
        if (this.project.getArtifact() != null) {
            artifacts.add(this.project.getArtifact());
        }
        if (this.project.getAttachedArtifacts() != null) {
            artifacts.addAll(this.project.getAttachedArtifacts());
        }
        if (this.select(artifacts, new Selector("pom")) == null) {
            Artifact projectArtifact = this.artifactFactory.createProjectArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
            projectArtifact.setFile(this.project.getFile());
            artifacts.add(projectArtifact);
        }
        LinkedHashMap<String, File> artifactFiles = new LinkedHashMap<String, File>(this.selectors.length);
        for (int i = 0; i < this.selectors.length; ++i) {
            if (StringUtils.isEmpty((String)this.selectors[i].getType())) {
                this.selectors[i].setType(this.project.getPackaging());
            }
            if (StringUtils.isEmpty((String)this.selectors[i].getClassifier())) {
                this.selectors[i].setClassifier(null);
            }
            this.getLog().debug((CharSequence)("Using selector " + this.selectors[i]));
            Artifact artifact = null;
            if (searchReactor) {
                artifact = this.select(artifacts, this.selectors[i]);
            }
            if (artifact == null || artifact.getFile() == null || !artifact.getFile().isFile()) {
                try {
                    Artifact tmp = this.factory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.shipVersion, this.selectors[i].getType(), this.selectors[i].getClassifier());
                    this.resolver.resolve(tmp, this.remoteRepos, this.local);
                    artifact = tmp;
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
                }
                catch (ArtifactNotFoundException e) {
                    // empty catch block
                }
            }
            if (artifact == null) {
                throw new MojoExecutionException("Could not find required artifact " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.shipVersion + ":" + this.selectors[i].getType() + ":" + this.selectors[i].getClassifier());
            }
            if (artifact.getFile() == null) {
                throw new MojoExecutionException("Resolved artifact " + artifact + " does not have a resolved file.");
            }
            if (!artifact.getFile().isFile()) {
                throw new MojoExecutionException("Resolved artifact " + artifact + "'s resolved file does not exist.");
            }
            artifactFiles.put(this.selectors[i].getId(), artifact.getFile());
        }
        this.getLog().info((CharSequence)"Shipping the following artifacts: ");
        Iterator i = artifactFiles.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.getLog().info((CharSequence)("  " + entry.getKey() + " --> " + entry.getValue()));
        }
        ScriptEngineManager mgr = new ScriptEngineManager();
        LinkedHashMap scriptVars = new LinkedHashMap();
        scriptVars.put("artifacts", Collections.unmodifiableMap(artifactFiles));
        scriptVars.put("log", this.getLog());
        scriptVars.put("settings", this.settings);
        scriptVars.put("wagonManager", this.wagonManager);
        ArrayList<URL> scripts = new ArrayList<URL>();
        File shipScriptDir = new File(this.project.getBasedir(), this.shipScriptDirectory);
        for (int i2 = 0; i2 < this.shipScripts.length; ++i2) {
            boolean found = false;
            if (shipScriptDir.isDirectory()) {
                this.getLog().debug((CharSequence)("Looking for scripts matching " + this.shipScripts[i2] + " in " + shipScriptDir));
                try {
                    List files = FileUtils.getFiles((File)shipScriptDir, (String)this.shipScripts[i2], null);
                    if (files.isEmpty()) {
                        throw new MojoExecutionException("Could not find any scripts matching " + this.shipScripts[i2] + " in " + shipScriptDir);
                    }
                    Iterator j = files.iterator();
                    while (j.hasNext()) {
                        File file = (File)j.next();
                        scripts.add(file.toURI().toURL());
                        found = true;
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not find scripts matching " + this.shipScripts[i2] + " in " + shipScriptDir, (Exception)e);
                }
            }
            if (this.alwaysUsePluginDependencies || !found) {
                this.getLog().debug((CharSequence)("Looking for scripts matching " + this.shipScripts[i2] + " in plugin dependencies"));
                Iterator j = this.pluginDependencies.iterator();
                while (j.hasNext()) {
                    Artifact artifact = (Artifact)j.next();
                    try {
                        JarFile zip = new JarFile(artifact.getFile());
                        Enumeration<JarEntry> entries = zip.entries();
                        while (entries.hasMoreElements()) {
                            URL resource;
                            JarEntry entry = entries.nextElement();
                            if (entry.isDirectory() || !mgr.isScriptPath(entry.getName()) || !SelectorUtils.matchPath((String)this.shipScripts[i2], (String)entry.getName(), (boolean)true) || (resource = Thread.currentThread().getContextClassLoader().getResource(entry.getName())) == null) continue;
                            this.getLog().debug((CharSequence)("Found script matchint " + this.shipScripts[i2] + " at " + resource));
                            scripts.add(resource);
                            found = true;
                        }
                    }
                    catch (ZipException e) {
                        this.getLog().warn((CharSequence)("Could not process plugin dependency " + artifact.toString()), (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Could not process plugin dependency " + artifact.toString()), (Throwable)e);
                    }
                }
            }
            if (found) continue;
            if (this.failOnMissingScripts) {
                throw new MojoExecutionException("Could not find scripts matching " + this.shipScripts[i2]);
            }
            this.getLog().info((CharSequence)("Could not find scripts matching " + this.shipScripts[i2]));
        }
        if (scripts.isEmpty()) {
            this.getLog().info((CharSequence)"No ship scripts were found. Nothing to do.");
        }
        Iterator i3 = scripts.iterator();
        while (i3.hasNext()) {
            URL script = (URL)i3.next();
            this.getLog().info((CharSequence)("Executing " + script));
            mgr.eval(script, this.encoding, scriptVars, this.getLog());
        }
    }

    private Artifact select(List artifacts, Selector selector) {
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (!StringUtils.equals((String)this.project.getGroupId(), (String)artifact.getGroupId()) || !StringUtils.equals((String)this.project.getArtifactId(), (String)artifact.getArtifactId()) || !selector.matches(artifact)) continue;
            return artifact;
        }
        return null;
    }
}

