/*
 * Copyright 2004-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.compass.core.lucene.engine.transaction.support.job;

import org.apache.lucene.index.IndexWriter;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.support.WriterHelper;
import org.compass.core.spi.InternalResource;

/**
 * A transaction job that creates updates a {@link org.compass.core.Resource}.
 *
 * @author kimchy
 */
public class UpdateTransactionJob implements TransactionJob {

    private final InternalResource resource;

    private final String resourceUID;

    public UpdateTransactionJob(InternalResource resource) {
        this.resource = resource;
        this.resourceUID = resource.getResourceKey().buildUID();
    }

    public String getSubIndex() {
        return resource.getSubIndex();
    }

    public String getResourceUID() {
        return resourceUID;
    }

    public InternalResource getResource() {
        return resource;
    }

    public void execute(IndexWriter writer, LuceneSearchEngineFactory sessionFactory) throws Exception {
        resource.attach(sessionFactory);
        WriterHelper.processUpdate(writer, resource);
    }

    @Override
    public String toString() {
        return "Job Update [" + resource.getResourceKey() + "] Resource [" + resource + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        UpdateTransactionJob that = (UpdateTransactionJob) o;
        return resourceUID.equals(that.resourceUID);
    }

    @Override
    public int hashCode() {
        return 29 * resourceUID.hashCode();
    }
}