/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.accessor;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.compass.core.accessor.Getter;

public class AccessorUtils {
    public static Class getCollectionParameter(Getter getter) {
        Type[] actualTypeArguments;
        if (!Collection.class.isAssignableFrom(getter.getReturnType())) {
            return null;
        }
        Type type = getter.getGenericReturnType();
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) != null && actualTypeArguments.length == 1) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    public static Class getMapKeyParameter(Getter getter) {
        Type[] actualTypeArguments;
        if (!Map.class.isAssignableFrom(getter.getReturnType())) {
            return null;
        }
        Type type = getter.getGenericReturnType();
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) != null && actualTypeArguments.length == 2) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    public static boolean isMapValueParameterArray(Getter getter) {
        Type[] actualTypeArguments;
        if (!Map.class.isAssignableFrom(getter.getReturnType())) {
            return false;
        }
        Type type = getter.getGenericReturnType();
        if (type == null) {
            return false;
        }
        return type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) != null && actualTypeArguments.length == 2 && actualTypeArguments[1] instanceof GenericArrayType;
    }

    public static boolean isMapValueParameterCollection(Getter getter) {
        Class paramType;
        Type[] actualTypeArguments;
        if (!Map.class.isAssignableFrom(getter.getReturnType())) {
            return false;
        }
        Type type = getter.getGenericReturnType();
        if (type == null) {
            return false;
        }
        return type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) != null && actualTypeArguments.length == 2 && actualTypeArguments[1] instanceof ParameterizedType && Collection.class.isAssignableFrom(paramType = (Class)((ParameterizedType)actualTypeArguments[1]).getRawType());
    }

    public static Class getMapValueParameter(Getter getter) {
        Type[] actualTypeArguments;
        if (!Map.class.isAssignableFrom(getter.getReturnType())) {
            return null;
        }
        Type type = getter.getGenericReturnType();
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) != null && actualTypeArguments.length == 2) {
            if (actualTypeArguments[1] instanceof GenericArrayType) {
                return (Class)((GenericArrayType)actualTypeArguments[1]).getGenericComponentType();
            }
            if (actualTypeArguments[1] instanceof ParameterizedType) {
                Class paramType = (Class)((ParameterizedType)actualTypeArguments[1]).getRawType();
                if (Collection.class.isAssignableFrom(paramType)) {
                    return (Class)((ParameterizedType)actualTypeArguments[1]).getActualTypeArguments()[0];
                }
            } else {
                return (Class)actualTypeArguments[1];
            }
        }
        return null;
    }
}

