/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.mapping.xsem.XmlIdMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;

public class LateBindingXsemMappingProcessor
implements MappingProcessor {
    private PropertyNamingStrategy namingStrategy;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.namingStrategy = namingStrategy;
        ((InternalCompassMapping)compassMapping).setPath(namingStrategy.getRootPath());
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            if (!(aliasMapping instanceof XmlObjectMapping)) continue;
            this.secondPass((XmlObjectMapping)aliasMapping, compassMapping);
        }
        return compassMapping;
    }

    private void secondPass(XmlObjectMapping xmlObjectMapping, CompassMapping fatherMapping) {
        xmlObjectMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), xmlObjectMapping.getAlias()));
        Iterator<Mapping> it = xmlObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping mapping = it.next();
            if (!(mapping instanceof XmlIdMapping)) continue;
            XmlIdMapping xmlIdMapping = (XmlIdMapping)mapping;
            xmlIdMapping.setInternal(true);
            xmlIdMapping.setPath(this.namingStrategy.buildPath(xmlObjectMapping.getPath(), xmlIdMapping.getName()));
        }
    }
}

