/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.json;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.json.JsonContentConverter;
import org.compass.core.json.JsonObject;
import org.compass.core.json.impl.converter.DefaultJSONContentConverterImpl;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.json.JsonContentMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.util.ClassUtils;

public class JsonContentMappingConverter
implements Converter,
CompassConfigurable {
    private static final Log log = LogFactory.getLog(JsonContentMappingConverter.class);
    private JsonContentConverter contentConverter;

    public void configure(CompassSettings settings) throws CompassException {
        String type = settings.getGloablSettings().getSetting("compass.jsem.contentConverter.type");
        if (type == null) {
            type = DefaultJSONContentConverterImpl.class.getName();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Usign Json content converter [" + type + "]"));
        }
        try {
            this.contentConverter = (JsonContentConverter)ClassUtils.forName(type, settings.getClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create jsonContent [" + type + "]", e);
        }
        if (this.contentConverter instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)this.contentConverter)).configure(settings);
        }
    }

    public JsonContentConverter getContentConverter() {
        return this.contentConverter;
    }

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        String sValue;
        if (root == null && !this.handleNulls(context)) {
            return false;
        }
        JsonContentMapping jsonContentMapping = (JsonContentMapping)mapping;
        if (root instanceof String) {
            sValue = (String)root;
        } else {
            JsonObject jsonObject = (JsonObject)root;
            sValue = this.contentConverter.toJSON(jsonObject);
        }
        String propertyName = jsonContentMapping.getPath().getPath();
        Property p = context.getResourceFactory().createProperty(propertyName, sValue, jsonContentMapping);
        resource.addProperty(p);
        return jsonContentMapping.getStore() != Property.Store.NO;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        JsonContentMapping jsonContentMapping = (JsonContentMapping)mapping;
        String propertyName = jsonContentMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null || this.isNullValue(context, p.getStringValue())) {
            return null;
        }
        return this.contentConverter.fromJSON(resource.getAlias(), p.getStringValue());
    }

    protected boolean handleNulls(MarshallingContext context) {
        return context.handleNulls();
    }

    protected boolean isNullValue(MarshallingContext context, String value) {
        return context.getResourceFactory().isNullValue(value);
    }
}

