/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.Resource;
import org.compass.core.accessor.AccessorUtils;
import org.compass.core.accessor.Getter;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.mapping.osem.AbstractCollectionMappingConverter;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceCollection;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceEntry;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceList;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceSet;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.CollectionMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.util.proxy.extractor.ProxyExtractorHelper;

public class CollectionMappingConverter
extends AbstractCollectionMappingConverter
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog(CollectionMappingConverter.class);
    private ProxyExtractorHelper proxyExtractorHelper;

    public void configure(CompassSettings settings) throws CompassException {
        this.proxyExtractorHelper = new ProxyExtractorHelper();
        this.proxyExtractorHelper.configure(settings);
    }

    protected int marshallIterateData(Object root, AbstractCollectionMapping colMapping, Resource resource, MarshallingContext context) {
        root = this.proxyExtractorHelper.initializeProxy(root);
        Object current = context.getAttribute("current");
        int count = 0;
        Mapping elementMapping = colMapping.getElementMapping();
        Collection col = (Collection)root;
        for (Object value : col) {
            context.setAttribute("current", current);
            boolean stored = elementMapping.getConverter().marshall(resource, value, elementMapping, context);
            if (!stored) continue;
            ++count;
        }
        return count;
    }

    protected AbstractCollectionMapping.CollectionType getRuntimeCollectionType(Object root) {
        if (root instanceof List) {
            return AbstractCollectionMapping.CollectionType.LIST;
        }
        if (root instanceof LinkedHashSet) {
            return AbstractCollectionMapping.CollectionType.LINKED_HASH_SET;
        }
        if (root instanceof EnumSet) {
            return AbstractCollectionMapping.CollectionType.ENUM_SET;
        }
        if (root instanceof SortedSet) {
            return AbstractCollectionMapping.CollectionType.SORTED_SET;
        }
        if (root instanceof Set) {
            return AbstractCollectionMapping.CollectionType.SET;
        }
        throw new IllegalStateException("Compass does not support collection class [" + root.getClass().getName() + "], please consider using either List or Set implementations");
    }

    protected Object createColObject(Getter getter, AbstractCollectionMapping.CollectionType collectionType, int size, AbstractCollectionMapping mapping, MarshallingContext context) {
        if (((CollectionMapping)mapping).isLazy().booleanValue()) {
            if (collectionType == AbstractCollectionMapping.CollectionType.LIST) {
                return new LazyReferenceList(context.getSession(), size);
            }
            if (collectionType == AbstractCollectionMapping.CollectionType.SET || collectionType == AbstractCollectionMapping.CollectionType.SORTED_SET || collectionType == AbstractCollectionMapping.CollectionType.LINKED_HASH_SET) {
                return new LazyReferenceSet(context.getSession(), size, collectionType);
            }
            throw new IllegalStateException("Lazy not supported for this type of collection [" + (Object)((Object)collectionType) + "]");
        }
        if (collectionType == AbstractCollectionMapping.CollectionType.LIST) {
            return new ArrayList(size);
        }
        if (collectionType == AbstractCollectionMapping.CollectionType.ENUM_SET) {
            return EnumSet.noneOf(AccessorUtils.getCollectionParameter(getter));
        }
        if (collectionType == AbstractCollectionMapping.CollectionType.SET) {
            return new HashSet(size);
        }
        if (collectionType == AbstractCollectionMapping.CollectionType.SORTED_SET) {
            return new TreeSet();
        }
        if (collectionType == AbstractCollectionMapping.CollectionType.LINKED_HASH_SET) {
            return new LinkedHashSet(size);
        }
        throw new IllegalStateException("Should not happen, internal compass error");
    }

    protected void addValue(Object col, int index, Object value, AbstractCollectionMapping mapping, MarshallingContext context) {
        if (((CollectionMapping)mapping).isLazy().booleanValue()) {
            ((LazyReferenceCollection)col).addLazyEntry((LazyReferenceEntry)value);
        } else {
            ((Collection)col).add(value);
        }
    }
}

