/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.xsem;

import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.xsem.SupportsXmlContentWrapper;
import org.compass.core.converter.xsem.XmlContentConverter;
import org.compass.core.util.ClassUtils;
import org.compass.core.xml.dom4j.converter.SAXReaderXmlContentConverter;
import org.compass.core.xml.dom4j.converter.STAXReaderXmlContentConverter;
import org.compass.core.xml.dom4j.converter.XPP3ReaderXmlContentConverter;
import org.compass.core.xml.dom4j.converter.XPPReaderXmlContentConverter;
import org.compass.core.xml.javax.converter.NodeXmlContentConverter;
import org.compass.core.xml.javax.converter.StaxNodeXmlContentConverter;
import org.compass.core.xml.jdom.converter.SAXBuilderXmlContentConverter;
import org.compass.core.xml.jdom.converter.STAXBuilderXmlContentConverter;

public abstract class XmlContentConverterUtils {
    public static XmlContentConverter createXmlContentConverter(CompassSettings settings) throws ConfigurationException {
        String wrapper;
        XmlContentConverter xmlContentConverter;
        String type = settings.getGloablSettings().getSetting("compass.xsem.contentConverter.type");
        if (type == null) {
            throw new ConfigurationException("[compass.xsem.contentConverter.type] configuration can not be found, please set it in the configuration settings");
        }
        if ("jdom-sax".equals(type)) {
            xmlContentConverter = new SAXBuilderXmlContentConverter();
        } else if ("jdom-stax".equals(type)) {
            xmlContentConverter = new STAXBuilderXmlContentConverter();
        } else if ("dom4j-stax".equals(type)) {
            xmlContentConverter = new STAXReaderXmlContentConverter();
        } else if ("dom4j-sax".equals(type)) {
            xmlContentConverter = new SAXReaderXmlContentConverter();
        } else if ("dom4j-xpp".equals(type)) {
            xmlContentConverter = new XPPReaderXmlContentConverter();
        } else if ("dom4j-xpp3".equals(type)) {
            xmlContentConverter = new XPP3ReaderXmlContentConverter();
        } else if ("javax-node".equals(type)) {
            xmlContentConverter = new NodeXmlContentConverter();
        } else if ("javax-stax".equals(type)) {
            xmlContentConverter = new StaxNodeXmlContentConverter();
        } else {
            try {
                xmlContentConverter = (XmlContentConverter)ClassUtils.forName(type, settings.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create xmlContent [" + type + "]", e);
            }
        }
        if (xmlContentConverter instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)xmlContentConverter)).configure(settings);
        }
        if (xmlContentConverter instanceof SupportsXmlContentWrapper && !((SupportsXmlContentWrapper)((Object)xmlContentConverter)).supports(wrapper = settings.getGloablSettings().getSetting("compass.xsem.contentConverter.wrapper", "prototype"))) {
            throw new SupportsXmlContentWrapper.NotSupportedXmlContentWrapperException(xmlContentConverter, wrapper);
        }
        return xmlContentConverter;
    }
}

