/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.engine.naming;

import java.util.Arrays;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.util.StringUtils;

public class DynamicPropertyPath
implements PropertyPath {
    private final String[] steps;
    private static final char delimiter = '/';
    private int hash;

    public DynamicPropertyPath(String step) {
        this.steps = new String[]{step.intern()};
    }

    public DynamicPropertyPath(String[] steps) {
        this.steps = steps;
    }

    public DynamicPropertyPath(PropertyPath root, String name) {
        if (root instanceof DynamicPropertyPath) {
            String[] rootSteps = ((DynamicPropertyPath)root).steps;
            this.steps = new String[rootSteps.length + 1];
            System.arraycopy(rootSteps, 0, this.steps, 0, rootSteps.length);
            this.steps[rootSteps.length] = name.intern();
        } else {
            this.steps = new String[2];
            this.steps[0] = root.getPath();
            this.steps[1] = name.intern();
        }
    }

    public String getPath() {
        return StringUtils.arrayToDelimitedString((Object[])this.steps, '/');
    }

    public PropertyPath hintStatic() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !(obj instanceof PropertyPath)) {
            return false;
        }
        if (obj instanceof DynamicPropertyPath) {
            DynamicPropertyPath path = (DynamicPropertyPath)obj;
            return Arrays.equals(this.steps, path.steps);
        }
        PropertyPath path = (PropertyPath)obj;
        return this.getPath().equals(path.getPath());
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (int index = 0; index < this.steps.length; ++index) {
                if (index > 0) {
                    h = h * 31 + 47;
                }
                h = this.hashCode(h, this.steps[index]);
            }
            this.hash = h;
        }
        return h;
    }

    private int hashCode(int hash, String string) {
        int h = hash;
        for (int i = 0; i < string.length(); ++i) {
            h = h * 31 + string.charAt(i);
        }
        return h;
    }
}

