/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.compass.core.CompassTermFreq;
import org.compass.core.CompassTermFreqsBuilder;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.engine.SearchEngineTermFrequencies;
import org.compass.core.impl.DefaultCompassTermFreq;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassTermFreqsBuilder
implements CompassTermFreqsBuilder {
    private InternalCompassSession session;
    private String[] propertyNames;
    private int size;
    private String[] aliases;
    private String[] subIndexes;
    private int minNorm = -1;
    private int maxNorm = -1;
    private CompassTermFreqsBuilder.Sort sort = CompassTermFreqsBuilder.Sort.FREQ;

    public DefaultCompassTermFreqsBuilder(InternalCompassSession session, String[] names) {
        this.session = session;
        this.propertyNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            ResourcePropertyLookup lookup = session.getMapping().getResourcePropertyLookup(names[i]);
            this.propertyNames[i] = lookup.getPath();
        }
        this.size = 10;
    }

    public CompassTermFreqsBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public CompassTermFreqsBuilder setAliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public CompassTermFreqsBuilder setTypes(Class ... types) {
        if (types == null) {
            this.aliases = null;
            return this;
        }
        String[] aliases = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ResourceMapping resourceMapping = this.session.getMapping().getRootMappingByClass(types[i]);
            aliases[i] = resourceMapping.getAlias();
        }
        this.setAliases(aliases);
        return this;
    }

    public CompassTermFreqsBuilder setSubIndexes(String ... subIndexes) {
        this.subIndexes = subIndexes;
        return this;
    }

    public CompassTermFreqsBuilder normalize(int min, int max) {
        this.minNorm = min;
        this.maxNorm = max;
        return this;
    }

    public CompassTermFreqsBuilder setSort(CompassTermFreqsBuilder.Sort sort) {
        this.sort = sort;
        return this;
    }

    public CompassTermFreq[] toTermFreqs() {
        SearchEngineInternalSearch internalSearch = this.session.getSearchEngine().internalSearch(this.subIndexes, this.aliases);
        SearchEngineTermFrequencies seTermFreqs = this.session.getSearchEngine().termFreq(this.propertyNames, this.size, internalSearch);
        CompassTermFreq[] termFreqs = seTermFreqs.getTerms();
        if (this.sort == CompassTermFreqsBuilder.Sort.TERM) {
            List<CompassTermFreq> list = Arrays.asList(termFreqs);
            Collections.sort(list, new Comparator<CompassTermFreq>(){

                @Override
                public int compare(CompassTermFreq o1, CompassTermFreq o2) {
                    return o1.getTerm().compareTo(o2.getTerm());
                }
            });
            termFreqs = list.toArray(new CompassTermFreq[list.size()]);
        }
        if (this.minNorm != -1 && this.maxNorm != -1) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (CompassTermFreq termFreq : termFreqs) {
                if (termFreq.getFreq() < (float)min) {
                    min = (int)termFreq.getFreq();
                }
                if (!(termFreq.getFreq() > (float)max)) continue;
                max = (int)termFreq.getFreq();
            }
            for (CompassTermFreq termFreq : termFreqs) {
                float freq = (int)termFreq.getFreq() == min ? (float)this.minNorm : ((int)termFreq.getFreq() == max ? (float)this.maxNorm : (float)this.minNorm + (termFreq.getFreq() - (float)min) / (float)(max - min) * (float)(this.maxNorm - this.minNorm));
                ((DefaultCompassTermFreq)termFreq).setFreq(freq);
            }
        }
        return termFreqs;
    }
}

