/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.util.HashMap;
import java.util.Map;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassMappingAware;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.TransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.async.AsyncTransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.lucene.LuceneTransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.mt.MTTransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.readcommitted.ReadCommittedTransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.search.SearchTransactionProcessorFactory;
import org.compass.core.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionProcessorManager {
    private final Map<String, TransactionProcessorFactory> transactionProcessors = new HashMap<String, TransactionProcessorFactory>();

    public TransactionProcessorManager(LuceneSearchEngineFactory searchEngineFactory) {
        CompassSettings settings = searchEngineFactory.getLuceneSettings().getSettings();
        Map<String, CompassSettings> processorsGroupsSettings = settings.getSettingGroups("compass.transaction.processor.");
        for (Map.Entry<String, CompassSettings> entry : processorsGroupsSettings.entrySet()) {
            Object type = entry.getValue().getSetting("type");
            if (type == null) continue;
            if (type instanceof String) {
                Object typeClass = type;
                if (((String)typeClass).equalsIgnoreCase("read_committed")) {
                    type = new ReadCommittedTransactionProcessorFactory();
                } else if (((String)typeClass).equalsIgnoreCase("lucene")) {
                    type = new LuceneTransactionProcessorFactory();
                } else if (((String)typeClass).equalsIgnoreCase("async")) {
                    type = new AsyncTransactionProcessorFactory();
                } else {
                    try {
                        type = ClassUtils.forName((String)typeClass, settings.getClassLoader()).newInstance();
                    }
                    catch (Exception e) {
                        throw new ConfigurationException("Failed to create custom transaction procesor factory class [" + (String)typeClass + "]", e);
                    }
                }
            }
            if (!(type instanceof TransactionProcessorFactory)) {
                throw new ConfigurationException("Transaction processor factory [" + type + "] is not of type [" + TransactionProcessorFactory.class.getName() + "]");
            }
            if (type instanceof CompassMappingAware) {
                ((CompassMappingAware)type).setCompassMapping(searchEngineFactory.getMapping());
            }
            if (type instanceof SearchEngineFactoryAware) {
                ((SearchEngineFactoryAware)type).setSearchEngineFactory(searchEngineFactory);
            }
            if (type instanceof CompassConfigurable) {
                ((CompassConfigurable)type).configure(searchEngineFactory.getLuceneSettings().getSettings());
            }
            this.transactionProcessors.put(entry.getKey(), (TransactionProcessorFactory)type);
        }
        this.addDefaulIfRequired(searchEngineFactory, "read_committed", ReadCommittedTransactionProcessorFactory.class);
        this.addDefaulIfRequired(searchEngineFactory, "lucene", LuceneTransactionProcessorFactory.class);
        this.addDefaulIfRequired(searchEngineFactory, "async", AsyncTransactionProcessorFactory.class);
        this.addDefaulIfRequired(searchEngineFactory, "search", SearchTransactionProcessorFactory.class);
        this.addDefaulIfRequired(searchEngineFactory, "mt", MTTransactionProcessorFactory.class);
    }

    private void addDefaulIfRequired(LuceneSearchEngineFactory searchEngineFactory, String key, Class<? extends TransactionProcessorFactory> type) {
        TransactionProcessorFactory processorFactory;
        if (this.transactionProcessors.containsKey(key)) {
            return;
        }
        try {
            processorFactory = type.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create instanco of [" + type.getName() + "]", e);
        }
        if (processorFactory instanceof CompassMappingAware) {
            ((CompassMappingAware)((Object)processorFactory)).setCompassMapping(searchEngineFactory.getMapping());
        }
        if (processorFactory instanceof SearchEngineFactoryAware) {
            ((SearchEngineFactoryAware)((Object)processorFactory)).setSearchEngineFactory(searchEngineFactory);
        }
        if (processorFactory instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)processorFactory)).configure(searchEngineFactory.getLuceneSettings().getSettings());
        }
        this.transactionProcessors.put(key, processorFactory);
    }

    public void close() {
        for (TransactionProcessorFactory transactionProcessorFactory : this.transactionProcessors.values()) {
            transactionProcessorFactory.close();
        }
    }

    public TransactionProcessorFactory getProcessorFactory(String name) {
        TransactionProcessorFactory processorFactory = this.transactionProcessors.get(name);
        if (processorFactory == null) {
            throw new SearchEngineException("Faile to find transaction processor factory bounded under [" + name + "]");
        }
        return processorFactory;
    }
}

