/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.DefaultLuceneSearchEngineHits;
import org.compass.core.lucene.engine.EmptyLuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.transaction.support.AbstractTransactionProcessor;
import org.compass.core.lucene.support.ResourceHelper;
import org.compass.core.spi.ResourceKey;

public abstract class AbstractSearchTransactionProcessor
extends AbstractTransactionProcessor {
    protected AbstractSearchTransactionProcessor(Log logger, LuceneSearchEngine searchEngine) {
        super(logger, searchEngine);
    }

    protected LuceneSearchEngineHits performFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        LuceneSearchEngineInternalSearch internalSearch = this.internalSearch(query.getSubIndexes(), query.getAliases());
        if (internalSearch.isEmpty()) {
            return new EmptyLuceneSearchEngineHits(this.searchEngine, internalSearch);
        }
        Filter qFilter = null;
        if (query.getFilter() != null) {
            qFilter = query.getFilter().getFilter();
        }
        Hits hits = this.findByQuery(internalSearch, query, qFilter);
        return new DefaultLuceneSearchEngineHits(hits, this.searchEngine, query, internalSearch);
    }

    protected LuceneSearchEngineInternalSearch performInternalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        return this.buildInternalSearch(subIndexes, aliases, true);
    }

    /*
     * Loose catch block
     */
    protected Resource[] performGet(ResourceKey resourceKey) throws SearchEngineException {
        LuceneIndexHolder indexHolder = this.indexManager.getIndexHoldersCache().getHolder(resourceKey.getSubIndex());
        try {
            Resource[] resourceArray;
            Term t = new Term(resourceKey.getUIDPath(), resourceKey.buildUID());
            TermDocs termDocs = null;
            try {
                termDocs = indexHolder.getIndexReader().termDocs(t);
                if (termDocs != null) {
                    Resource[] resourceArray2 = ResourceHelper.hitsToResourceArray(termDocs, indexHolder.getIndexReader(), this.searchEngine);
                    return resourceArray2;
                }
                resourceArray = new Resource[]{};
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to search for property [" + resourceKey + "]", e);
            }
            finally {
                try {
                    if (termDocs != null) {
                        termDocs.close();
                    }
                }
                catch (IOException e) {}
            }
            return resourceArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            indexHolder.release();
        }
    }
}

