/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.TransactionProcessor;
import org.compass.core.lucene.search.CacheableMultiReader;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;

public abstract class AbstractTransactionProcessor
implements TransactionProcessor {
    protected final Log logger;
    protected final LuceneSearchEngine searchEngine;
    protected final LuceneSearchEngineFactory searchEngineFactory;
    protected final LuceneSearchEngineIndexManager indexManager;
    protected final CompassMapping mapping;

    protected AbstractTransactionProcessor(Log logger, LuceneSearchEngine searchEngine) {
        this.logger = logger;
        this.searchEngine = searchEngine;
        this.searchEngineFactory = searchEngine.getSearchEngineFactory();
        this.indexManager = this.searchEngineFactory.getLuceneIndexManager();
        this.mapping = searchEngine.getSearchEngineFactory().getMapping();
    }

    protected ResourceMapping getResourceMapping(String alias) {
        return this.mapping.getRootMappingByAlias(alias);
    }

    protected LuceneSearchEngineInternalSearch buildInternalSearch(String[] subIndexes, String[] aliases, boolean useFieldCache) throws SearchEngineException {
        ArrayList<LuceneIndexHolder> indexHoldersToClose = new ArrayList<LuceneIndexHolder>();
        try {
            String[] calcSubIndexes = this.indexManager.getStore().calcSubIndexes(subIndexes, aliases);
            if (!useFieldCache) {
                ArrayList<IndexReader> readers = new ArrayList<IndexReader>(calcSubIndexes.length);
                LuceneIndexHolder lastNonEmptyIndexHolder = null;
                for (String subIndex : calcSubIndexes) {
                    LuceneIndexHolder indexHolder = this.indexManager.getIndexHoldersCache().getHolder(subIndex);
                    indexHoldersToClose.add(indexHolder);
                    if (indexHolder.getIndexReader().numDocs() <= 0) continue;
                    readers.add(indexHolder.getIndexReader());
                    lastNonEmptyIndexHolder = indexHolder;
                }
                if (readers.size() == 0) {
                    return new LuceneSearchEngineInternalSearch(this.searchEngine, indexHoldersToClose);
                }
                if (readers.size() == 1) {
                    return new LuceneSearchEngineInternalSearch(this.searchEngine, lastNonEmptyIndexHolder, indexHoldersToClose);
                }
                CacheableMultiReader reader = new CacheableMultiReader(readers.toArray(new IndexReader[readers.size()]), false);
                IndexSearcher searcher = this.indexManager.openIndexSearcher((IndexReader)reader);
                return new LuceneSearchEngineInternalSearch(this.searchEngine, (IndexReader)reader, (Searcher)searcher, indexHoldersToClose);
            }
            ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>(calcSubIndexes.length);
            LuceneIndexHolder lastNonEmptyIndexHolder = null;
            for (String subIndex : calcSubIndexes) {
                LuceneIndexHolder indexHolder = this.indexManager.getIndexHoldersCache().getHolder(subIndex);
                indexHoldersToClose.add(indexHolder);
                if (indexHolder.getIndexReader().numDocs() <= 0) continue;
                searchers.add(indexHolder.getIndexSearcher());
                lastNonEmptyIndexHolder = indexHolder;
            }
            if (searchers.size() == 0) {
                return new LuceneSearchEngineInternalSearch(this.searchEngine, indexHoldersToClose);
            }
            if (searchers.size() == 1) {
                return new LuceneSearchEngineInternalSearch(this.searchEngine, lastNonEmptyIndexHolder, indexHoldersToClose);
            }
            MultiSearcher searcher = this.indexManager.openMultiSearcher((Searchable[])searchers.toArray(new IndexSearcher[searchers.size()]));
            return new LuceneSearchEngineInternalSearch(this.searchEngine, searcher, indexHoldersToClose);
        }
        catch (Exception e) {
            for (LuceneIndexHolder indexHolder : indexHoldersToClose) {
                indexHolder.release();
            }
            throw new SearchEngineException("Failed to open Lucene reader/searcher", e);
        }
    }

    protected Hits findByQuery(LuceneSearchEngineInternalSearch internalSearch, LuceneSearchEngineQuery searchEngineQuery, Filter filter) throws SearchEngineException {
        Hits hits;
        Query query = searchEngineQuery.getQuery();
        if (searchEngineQuery.isRewrite()) {
            try {
                query = query.rewrite(internalSearch.getReader());
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to rewrite query [" + query.toString() + "]", e);
            }
        }
        Sort sort = searchEngineQuery.getSort();
        try {
            hits = filter == null ? internalSearch.getSearcher().search(query, sort) : internalSearch.getSearcher().search(query, filter, sort);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to search with query [" + query + "]", e);
        }
        return hits;
    }

    protected boolean isInvalidateCacheOnCommit() {
        return this.searchEngine.getSettings().getSettingAsBoolean("compass.transaction.clearCacheOnCommit", true);
    }

    protected final String getSettingName(String settingName) {
        return "compass.transaction.processor." + this.getName() + "." + settingName;
    }
}

