/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support;

import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceHashing {
    UID,
    SUBINDEX;


    public int hash(ResourceKey resourceKey) {
        switch (this) {
            case UID: {
                return CollectionUtils.absHash(resourceKey.buildUID());
            }
            case SUBINDEX: {
                return CollectionUtils.absHash(resourceKey.getSubIndex());
            }
        }
        throw new IllegalStateException("Intenral error in Compass");
    }

    public int hash(TransactionJob job) {
        if (job.getResourceUID() == null) {
            return CollectionUtils.absHash(job.getSubIndex());
        }
        switch (this) {
            case UID: {
                return CollectionUtils.absHash(job.getResourceUID());
            }
            case SUBINDEX: {
                return CollectionUtils.absHash(job.getSubIndex());
            }
        }
        throw new IllegalStateException("Intenral error in Compass");
    }

    public static ResourceHashing fromName(String name) {
        if ("uid".equalsIgnoreCase(name)) {
            return UID;
        }
        if ("subindex".equalsIgnoreCase(name)) {
            return SUBINDEX;
        }
        throw new IllegalArgumentException("No resource hashing found for [" + name + "]");
    }
}

