/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.compass.core.lucene.engine.transaction.support.ResourceEnhancer;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public abstract class WriterHelper {
    public static void processCreate(IndexWriter writer, InternalResource resource) throws IOException {
        ResourceEnhancer.Result result = ResourceEnhancer.enahanceResource(resource);
        writer.addDocument(result.getDocument(), result.getAnalyzer());
    }

    public static void processUpdate(IndexWriter writer, InternalResource resource) throws IOException {
        ResourceEnhancer.Result result = ResourceEnhancer.enahanceResource(resource);
        writer.updateDocument(new Term(resource.getResourceKey().getUIDPath(), resource.getResourceKey().buildUID()), result.getDocument(), result.getAnalyzer());
    }

    public static void processDelete(IndexWriter writer, ResourceKey resourceKey) throws IOException {
        writer.deleteDocuments(new Term(resourceKey.getUIDPath(), resourceKey.buildUID()));
    }

    public static void processDelete(IndexWriter writer, Query query) throws IOException {
        writer.deleteDocuments(query);
    }
}

