/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.support.search;

import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassException;
import org.compass.core.CompassHit;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.support.search.CompassSearchCommand;
import org.compass.core.support.search.CompassSearchResults;
import org.compass.core.util.StringUtils;

public class CompassSearchHelper {
    private CompassTemplate compassTemplate;
    private Integer pageSize;

    public CompassSearchHelper(Compass compass) {
        this(compass, null);
    }

    public CompassSearchHelper(Compass compass, Integer pageSize) {
        this.compassTemplate = new CompassTemplate(compass);
        this.pageSize = pageSize;
    }

    public CompassSearchResults search(final CompassSearchCommand command) throws CompassException {
        if (!StringUtils.hasText(command.getQuery()) && command.getCompassQuery() == null) {
            return new CompassSearchResults(new CompassHit[0], 0L, 0);
        }
        return (CompassSearchResults)this.compassTemplate.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return CompassSearchHelper.this.performSearch(command, session);
            }
        });
    }

    public CompassSearchResults searchLocal(final CompassSearchCommand command) throws CompassException {
        if (!StringUtils.hasText(command.getQuery()) && command.getCompassQuery() == null) {
            return new CompassSearchResults(new CompassHit[0], 0L, 0);
        }
        return (CompassSearchResults)this.compassTemplate.executeLocal(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return CompassSearchHelper.this.performSearch(command, session);
            }
        });
    }

    protected CompassSearchResults performSearch(CompassSearchCommand searchCommand, CompassSession session) {
        CompassDetachedHits detachedHits;
        long time = System.currentTimeMillis();
        CompassQuery query = this.buildQuery(searchCommand, session);
        CompassHits hits = query.hits();
        CompassSearchResults.Page[] pages = null;
        if (this.pageSize == null) {
            this.doProcessBeforeDetach(searchCommand, session, hits, -1, -1);
            detachedHits = hits.detach();
            this.doProcessAfterDetach(searchCommand, session, detachedHits);
        } else {
            CompassSearchResults.Page lastPage;
            int from;
            int iPageSize = this.pageSize;
            int page = 0;
            int hitsLength = hits.getLength();
            if (searchCommand.getPage() != null) {
                page = searchCommand.getPage();
            }
            if ((from = page * iPageSize) > hits.getLength()) {
                from = Math.max(0, hits.getLength() - iPageSize);
                this.doProcessBeforeDetach(searchCommand, session, hits, from, hitsLength - from);
                detachedHits = hits.detach(from, hitsLength - from);
            } else if (from + iPageSize > hitsLength) {
                this.doProcessBeforeDetach(searchCommand, session, hits, from, hitsLength - from);
                detachedHits = hits.detach(from, hitsLength - from);
            } else {
                this.doProcessBeforeDetach(searchCommand, session, hits, from, iPageSize);
                detachedHits = hits.detach(from, iPageSize);
            }
            this.doProcessAfterDetach(searchCommand, session, detachedHits);
            int numberOfPages = (int)Math.ceil((float)hitsLength / (float)iPageSize);
            pages = new CompassSearchResults.Page[numberOfPages];
            for (int i = 0; i < pages.length; ++i) {
                pages[i] = new CompassSearchResults.Page();
                pages[i].setFrom(i * iPageSize + 1);
                pages[i].setSize(iPageSize);
                pages[i].setTo((i + 1) * iPageSize);
                if (from >= pages[i].getFrom() - 1 && from < pages[i].getTo()) {
                    pages[i].setSelected(true);
                    continue;
                }
                pages[i].setSelected(false);
            }
            if (numberOfPages > 0 && (lastPage = pages[numberOfPages - 1]).getTo() > hitsLength) {
                lastPage.setSize(hitsLength - lastPage.getFrom() + 1);
                lastPage.setTo(hitsLength);
            }
        }
        time = System.currentTimeMillis() - time;
        CompassSearchResults searchResults = new CompassSearchResults(detachedHits.getHits(), time, hits.length());
        searchResults.setPages(pages);
        return searchResults;
    }

    protected CompassQuery buildQuery(CompassSearchCommand searchCommand, CompassSession session) {
        if (searchCommand.getCompassQuery() != null) {
            return searchCommand.getCompassQuery();
        }
        return session.queryBuilder().queryString(searchCommand.getQuery().trim()).toQuery();
    }

    protected void doProcessBeforeDetach(CompassSearchCommand searchCommand, CompassSession session, CompassHits hits, int from, int size) {
    }

    protected void doProcessAfterDetach(CompassSearchCommand searchCommand, CompassSession session, CompassDetachedHits hits) {
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

