/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import org.compass.core.CompassException;
import org.compass.core.engine.SearchEngine;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionFactory;

public abstract class AbstractTransaction
implements InternalCompassTransaction {
    private boolean begun;
    protected final TransactionFactory transactionFactory;

    protected AbstractTransaction(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setBegun(boolean begun) {
        this.begun = begun;
    }

    public boolean isBegun() {
        return this.begun;
    }

    public void commit() throws CompassException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        this.doCommit();
    }

    public void rollback() throws CompassException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        this.doRollback();
    }

    public SearchEngine getSearchEngine() {
        return ((InternalCompassSession)this.getSession()).getSearchEngine();
    }

    protected abstract void doCommit() throws CompassException;

    protected abstract void doRollback() throws CompassException;
}

