/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.jdom.converter;

import java.io.IOException;
import java.io.Writer;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.XmlContentConverter;
import org.compass.core.util.StringBuilderWriter;
import org.compass.core.xml.XmlObject;
import org.compass.core.xml.jdom.JDomXmlObject;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractXmlOutputterXmlContentConverter
implements XmlContentConverter,
CompassConfigurable {
    private boolean compact;

    public void configure(CompassSettings settings) throws CompassException {
        String outputFormat = settings.getGloablSettings().getSetting("compass.xsem.contentConverter.jdom.outputFormat", "default");
        if ("default".equals(outputFormat)) {
            this.compact = false;
        } else if ("compact".equals(outputFormat)) {
            this.compact = true;
        }
    }

    public String toXml(XmlObject xmlObject) throws ConversionException {
        JDomXmlObject jDomXmlObject = (JDomXmlObject)xmlObject;
        XMLOutputter outp = new XMLOutputter();
        if (this.compact) {
            outp.setFormat(Format.getCompactFormat());
        }
        StringBuilderWriter stringWriter = StringBuilderWriter.Cached.cached();
        try {
            outp.output(jDomXmlObject.getElement(), (Writer)stringWriter);
        }
        catch (IOException e) {
            throw new ConversionException("This should not happen", e);
        }
        return stringWriter.toString();
    }
}

