/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.sql.SQLException;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.mapping.ResourceMapping;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.ibatis.IndexStatement;
import org.compass.gps.device.ibatis.SqlMapGpsDeviceException;
import org.compass.gps.device.ibatis.SqlMapIndexEntity;
import org.compass.gps.device.support.parallel.AbstractParallelGpsDevice;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class SqlMapClientGpsDevice
extends AbstractParallelGpsDevice {
    private SqlMapClient sqlMapClient;
    private String[] selectStatementsIds;
    private Object[] statementsParameterObjects;
    private int pageSize = 200;

    public SqlMapClientGpsDevice() {
    }

    public SqlMapClientGpsDevice(String deviceName, SqlMapClient sqlMapClient, IndexStatement ... statements) {
        this.setName(deviceName);
        this.sqlMapClient = sqlMapClient;
        this.setIndexStatements(statements);
    }

    public SqlMapClientGpsDevice(String deviceName, SqlMapClient sqlMapClient, String ... selectStatementsIds) {
        this(deviceName, sqlMapClient, selectStatementsIds, (Object[])null);
    }

    public SqlMapClientGpsDevice(String deviceName, SqlMapClient sqlMapClient, String[] selectStatementsIds, Object[] statementsParameterObjects) {
        this.setName(deviceName);
        this.sqlMapClient = sqlMapClient;
        this.selectStatementsIds = selectStatementsIds;
        this.statementsParameterObjects = statementsParameterObjects;
    }

    protected void doStart() throws CompassGpsException {
        if (this.sqlMapClient == null) {
            throw new IllegalArgumentException(this.buildMessage("Must set sqlMapClaient property"));
        }
        if (this.selectStatementsIds == null) {
            throw new IllegalArgumentException(this.buildMessage("Must set selectStatementsIds property"));
        }
        if (this.selectStatementsIds.length == 0) {
            throw new IllegalArgumentException(this.buildMessage("selectStatementsIds property must have at least one entry"));
        }
        if (this.statementsParameterObjects != null && this.statementsParameterObjects.length != this.selectStatementsIds.length) {
            throw new IllegalArgumentException(this.buildMessage("Once the statementsParameterObjects property is set, it must have the same length as the selectStatementsIds property"));
        }
    }

    protected IndexEntity[] doGetIndexEntities() throws CompassGpsException {
        ExtendedSqlMapClient extSqlMapClient = (ExtendedSqlMapClient)this.sqlMapClient;
        IndexEntity[] entities = new IndexEntity[this.selectStatementsIds.length];
        for (int i = 0; i < this.selectStatementsIds.length; ++i) {
            String statementId = this.selectStatementsIds[i];
            MappedStatement statement = extSqlMapClient.getDelegate().getMappedStatement(statementId);
            if (statement == null) {
                throw new IllegalArgumentException("Failed to find statement for [" + statementId + "]");
            }
            Class resultClass = statement.getResultMap().getResultClass();
            ResourceMapping resourceMapping = ((CompassGpsInterfaceDevice)this.getGps()).getMappingForEntityForIndex(resultClass);
            if (resourceMapping == null) {
                throw new IllegalArgumentException("Failed to find mapping for class [" + resultClass.getName() + "]");
            }
            Object parameterObject = null;
            if (this.statementsParameterObjects != null) {
                parameterObject = this.statementsParameterObjects[i];
            }
            entities[i] = new SqlMapIndexEntity(resultClass.getName(), resourceMapping.getSubIndexHash().getSubIndexes(), statementId, parameterObject);
        }
        return entities;
    }

    protected IndexEntitiesIndexer doGetIndexEntitiesIndexer() {
        return new SqlMapIndexer();
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public void setIndexStatements(IndexStatement ... statements) {
        this.selectStatementsIds = new String[statements.length];
        this.statementsParameterObjects = new Object[statements.length];
        for (int i = 0; i < statements.length; ++i) {
            this.selectStatementsIds[i] = statements[i].getStatementId();
            this.statementsParameterObjects[i] = statements[i].getParam();
        }
    }

    public void setSelectStatementsIds(String ... statementsNames) {
        this.selectStatementsIds = statementsNames;
    }

    public void setStatementsParameterObjects(Object[] statementsParameterObjects) {
        this.statementsParameterObjects = statementsParameterObjects;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public class SqlMapClientGpsDeviceRowHandler
    implements RowHandler {
        private SqlMapIndexEntity indexEntity;
        private CompassSession session;
        private int pageSize;
        private int pageCount = 0;
        private int currentItem = 1;

        public SqlMapClientGpsDeviceRowHandler(SqlMapIndexEntity indexEntity, CompassSession session, int pageSize) {
            this.session = session;
            this.pageSize = pageSize;
            this.indexEntity = indexEntity;
        }

        public void handleRow(Object o) {
            this.session.create(o);
            if (this.currentItem == this.pageSize) {
                if (SqlMapClientGpsDevice.this.log.isTraceEnabled()) {
                    SqlMapClientGpsDevice.this.log.trace((Object)SqlMapClientGpsDevice.this.buildMessage("Indexing [" + this.indexEntity.getName() + "] page number [" + this.pageCount + "]"));
                }
                this.session.evictAll();
                ++this.pageCount;
                this.currentItem = 0;
            }
            ++this.currentItem;
        }
    }

    private class SqlMapIndexer
    implements IndexEntitiesIndexer {
        private SqlMapIndexer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performIndex(CompassSession session, IndexEntity[] entities) throws CompassException {
            for (IndexEntity entity : entities) {
                SqlMapIndexEntity indexEntity = (SqlMapIndexEntity)entity;
                SqlMapSession sqlMapSession = SqlMapClientGpsDevice.this.getSqlMapClient().openSession();
                try {
                    sqlMapSession.startTransaction();
                    if (SqlMapClientGpsDevice.this.log.isDebugEnabled()) {
                        SqlMapClientGpsDevice.this.log.debug((Object)SqlMapClientGpsDevice.this.buildMessage("Indexing select statement id [" + indexEntity.getStatementId() + "]"));
                    }
                    sqlMapSession.queryWithRowHandler(indexEntity.getStatementId(), indexEntity.getParam(), (RowHandler)new SqlMapClientGpsDeviceRowHandler(indexEntity, session, SqlMapClientGpsDevice.this.pageSize));
                    session.evictAll();
                    sqlMapSession.commitTransaction();
                }
                catch (SQLException e) {
                    throw new SqlMapGpsDeviceException("Failed to fetch paginated list for statement [" + indexEntity.getStatementId() + "]", e);
                }
                finally {
                    try {
                        try {
                            sqlMapSession.endTransaction();
                        }
                        catch (Exception e) {
                            SqlMapClientGpsDevice.this.log.warn((Object)SqlMapClientGpsDevice.this.buildMessage("Failed to close sqlMap session, ignoring"), (Throwable)e);
                        }
                    }
                    finally {
                        sqlMapSession.close();
                    }
                }
            }
        }
    }
}

