/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.terracotta.TerracottaDirectory;
import org.compass.needle.terracotta.TerracottaFile;

public class TerracottaIndexOutput2
extends IndexOutput {
    private final int bufferSize;
    private final int flushRate;
    private final String name;
    private TerracottaFile file;
    private byte[] firstBucketEntry;
    private byte[] buffer;
    private int bufferPosition;
    private int currentBucketIndex;
    private long length;
    private long position;
    private boolean open;
    private boolean seekOccured;
    private ArrayList<byte[]> flushBuckets;

    TerracottaIndexOutput2(TerracottaDirectory dir, String name) throws IOException {
        this.name = name;
        this.bufferSize = dir.getBufferSize();
        this.flushRate = dir.getFlushRate();
        this.file = new TerracottaFile();
        dir.addFile(name, this.file);
        this.file.lock();
        this.file.addBuffer(0);
        this.file.unlock();
        this.open = true;
        this.buffer = new byte[this.bufferSize];
        this.flushBuckets = new ArrayList(this.flushRate);
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.bufferSize) {
            if (this.seekOccured) {
                throw new IOException("Seek occured and overflowed first buffer for file [" + this.name + "]");
            }
            this.flushBucket(true);
        }
        this.buffer[this.bufferPosition++] = b;
        if (!this.seekOccured) {
            ++this.length;
            ++this.position;
        }
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        if (!this.seekOccured) {
            this.position += (long)len;
            this.length += (long)len;
        }
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.bufferSize) {
                if (this.seekOccured) {
                    throw new IOException("Seek occured and overflowed first bucket for file [" + this.name + "]");
                }
                this.flushBucket(true);
            }
            int bytesToCopy = len < (remainInBuffer = this.bufferSize - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset, this.buffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.flushBucket(false);
        this.forceFlushBuckets(this.firstBucketEntry);
        this.buffer = null;
        this.firstBucketEntry = null;
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        if (pos >= (long)this.bufferSize) {
            throw new IOException("seek called outside of first buffer boundries for file [" + this.name + "]");
        }
        if (this.firstBucketEntry == null) {
            this.firstBucketEntry = new byte[this.bufferPosition];
            System.arraycopy(this.buffer, 0, this.firstBucketEntry, 0, this.bufferPosition);
        } else if (!this.seekOccured) {
            this.flushBucket(this.buffer, this.bufferPosition, true);
        }
        this.position = pos;
        this.currentBucketIndex = 0;
        this.bufferPosition = (int)pos;
        this.buffer = this.firstBucketEntry;
        this.seekOccured = true;
    }

    public long length() throws IOException {
        return this.length;
    }

    private void flushBucket(boolean forceFlush) throws IOException {
        if (this.currentBucketIndex == 0) {
            if (this.firstBucketEntry == null) {
                this.firstBucketEntry = new byte[this.bufferPosition];
                System.arraycopy(this.buffer, 0, this.firstBucketEntry, 0, this.bufferPosition);
            }
        } else if (this.bufferPosition > 0) {
            this.flushBucket(this.buffer, this.bufferPosition, forceFlush);
        }
        ++this.currentBucketIndex;
        this.bufferPosition = 0;
    }

    private void flushBucket(byte[] buffer, int length, boolean forceFlush) throws IOException {
        byte[] data = new byte[length];
        System.arraycopy(buffer, 0, data, 0, length);
        this.flushBuckets.add(data);
        if (this.flushBuckets.size() >= this.flushRate && forceFlush) {
            this.forceFlushBuckets(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceFlushBuckets(byte[] firstBuffer) throws IOException {
        if (this.flushBuckets.size() == 0 && firstBuffer == null) {
            return;
        }
        this.file.lock();
        try {
            if (!this.flushBuckets.isEmpty()) {
                byte[][] newBuffers = (byte[][])this.flushBuckets.toArray((T[])new byte[this.flushBuckets.size()][]);
                this.file.addBuffers(newBuffers);
            }
            if (firstBuffer != null) {
                this.file.setLength(this.length);
                this.file.setLastModified(System.currentTimeMillis());
                this.file.setFirstBuffer(firstBuffer);
            }
        }
        finally {
            this.file.unlock();
            this.flushBuckets.clear();
        }
    }
}

