/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.dhatim.fastexcel.reader.CellAddress;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.ReadableWorkbook;

public class Cell {
    private static final long DAY_MILLISECONDS = 86400000L;
    private final ReadableWorkbook workbook;
    private final Object value;
    private final String formula;
    private final CellType type;
    private final CellAddress address;
    private final String rawValue;
    private final String dataFormatId;
    private final String dataFormatString;

    Cell(ReadableWorkbook workbook, CellType type, Object value, CellAddress address, String formula, String rawValue) {
        this(workbook, type, value, address, formula, rawValue, null, null);
    }

    Cell(ReadableWorkbook workbook, CellType type, Object value, CellAddress address, String formula, String rawValue, String dataFormatId, String dataFormatString) {
        this.workbook = workbook;
        this.type = type;
        this.value = value;
        this.address = address;
        this.formula = formula;
        this.rawValue = rawValue;
        this.dataFormatId = dataFormatId;
        this.dataFormatString = dataFormatString;
    }

    public CellType getType() {
        return this.type;
    }

    public int getColumnIndex() {
        return this.address.getColumn();
    }

    public CellAddress getAddress() {
        return this.address;
    }

    public Object getValue() {
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getFormula() {
        return this.formula;
    }

    public BigDecimal asNumber() {
        this.requireType(CellType.NUMBER);
        return (BigDecimal)this.value;
    }

    public LocalDateTime asDate() {
        if (this.type == CellType.NUMBER) {
            return this.convertToDate(Double.parseDouble(this.rawValue));
        }
        if (this.type == CellType.EMPTY) {
            return null;
        }
        throw new ExcelReaderException("Wrong cell type " + (Object)((Object)this.type) + " for date value");
    }

    private LocalDateTime convertToDate(double value) {
        int wholeDays = (int)Math.floor(value);
        long millisecondsInDay = (long)((value - (double)wholeDays) * 8.64E7 + 0.5);
        int startYear = 1900;
        int dayAdjust = -1;
        if (this.workbook.isDate1904()) {
            startYear = 1904;
            dayAdjust = 1;
        } else if (wholeDays < 61) {
            dayAdjust = 0;
        }
        LocalDate localDate = LocalDate.of(startYear, 1, 1).plusDays((long)wholeDays + (long)dayAdjust - 1L);
        LocalTime localTime = LocalTime.ofNanoOfDay(millisecondsInDay * 1000000L);
        return LocalDateTime.of(localDate, localTime);
    }

    public Boolean asBoolean() {
        this.requireType(CellType.BOOLEAN);
        return (Boolean)this.value;
    }

    public String asString() {
        this.requireType(CellType.STRING);
        return this.value == null ? "" : (String)this.value;
    }

    private void requireType(CellType requiredType) {
        if (this.type != requiredType && this.type != CellType.EMPTY) {
            throw new ExcelReaderException("Wrong cell type " + (Object)((Object)this.type) + ", wanted " + (Object)((Object)requiredType));
        }
    }

    public String getText() {
        return this.value == null ? "" : this.value.toString();
    }

    public Integer getDataFormatId() {
        if (this.dataFormatId == null) {
            return null;
        }
        return Integer.parseInt(this.dataFormatId);
    }

    public String getDataFormatString() {
        return this.dataFormatString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append((Object)this.type).append(' ');
        if (this.value == null) {
            sb.append("null");
        } else {
            sb.append('\"').append(this.value).append('\"');
        }
        return sb.append(']').toString();
    }
}

