/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ASiCWithXAdESService
extends AbstractASiCSignatureService<ASiCWithXAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithXAdESService.class);
    public static final String XPATH_SIGNATURE_ID = "//ds:Signature/@Id";

    public ASiCWithXAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with XAdES created");
    }

    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        GetDataToSignASiCWithXAdESHelper getDataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        return this.getXAdESService().getContentTimestamp(getDataToSignHelper.getSignedDocuments(), (XAdESSignatureParameters)parameters);
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, dataToSignHelper.getExistingSignature());
        return this.getXAdESService().getDataToSign(dataToSignHelper.getToBeSigned(), xadesParameters);
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters, SignatureValue signatureValue) {
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertSigningDateInCertificateValidityRange((AbstractSignatureParameters)parameters);
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        List signatures = dataToSignHelper.getSignatures();
        List manifestFiles = dataToSignHelper.getManifestFiles();
        List signedDocuments = dataToSignHelper.getSignedDocuments();
        XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, dataToSignHelper.getExistingSignature());
        DSSDocument newSignature = this.getXAdESService().signDocument(dataToSignHelper.getToBeSigned(), xadesParameters, signatureValue);
        String newSignatureFilename = dataToSignHelper.getSignatureFilename();
        newSignature.setName(newSignatureFilename);
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters)) {
            Iterator iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual((String)newSignatureFilename, (String)((DSSDocument)iterator.next()).getName())) continue;
                iterator.remove();
            }
        }
        signatures.add(newSignature);
        DSSDocument asicSignature = this.buildASiCContainer(signedDocuments, signatures, manifestFiles, asicParameters);
        asicSignature.setName(this.getFinalFileName(asicSignature, SigningOperation.SIGN, parameters.getSignatureLevel(), parameters.aSiC().getContainerType()));
        parameters.reinitDeterministicId();
        return asicSignature;
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithXAdESSignatureParameters parameters) {
        if (!ASiCUtils.isASiCContainer((DSSDocument)toExtendDocument) || !ASiCUtils.isArchiveContainsCorrectSignatureFileWithExtension((DSSDocument)toExtendDocument, (String)".xml")) {
            throw new DSSException("Unsupported file type");
        }
        this.extractCurrentArchive(toExtendDocument);
        List signatureDocuments = this.getEmbeddedSignatures();
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        for (DSSDocument signature : signatureDocuments) {
            XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, null);
            if (ASiCUtils.isOpenDocument((DSSDocument)this.getEmbeddedMimetype())) {
                xadesParameters.setDetachedContents(OpenDocumentSupportUtils.getOpenDocumentCoverage(this.archiveContent));
            } else {
                xadesParameters.setDetachedContents(this.getEmbeddedSignedDocuments());
            }
            DSSDocument extendDocument = this.getXAdESService().extendDocument(signature, xadesParameters);
            extendDocument.setName(signature.getName());
            extendedDocuments.add(extendDocument);
        }
        DSSDocument extensionResult = this.mergeArchiveAndExtendedSignatures(toExtendDocument, extendedDocuments);
        extensionResult.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), parameters.aSiC().getContainerType()));
        return extensionResult;
    }

    public DSSDocument removeSignatureById(DSSDocument zipArchive, String signatureId) throws IOException {
        if (signatureId == null || signatureId.isEmpty()) {
            throw new DSSException("Signature id should be defined");
        }
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor(zipArchive);
        ASiCExtractResult archiveContent = extractor.extract();
        List signatureDocs = archiveContent.getSignatureDocuments();
        ArrayList<DSSDocument> sigantureToRemove = new ArrayList<DSSDocument>();
        for (DSSDocument signature : signatureDocs) {
            Document document = DomUtils.buildDOM((DSSDocument)signature);
            String sigId = DomUtils.getValue((Node)document, (String)XPATH_SIGNATURE_ID);
            if (!signatureId.equals(sigId)) continue;
            sigantureToRemove.add(signature);
        }
        signatureDocs.removeAll(sigantureToRemove);
        DSSDocument asicSignature = this.mergeArchiveAndExtendedSignatures(zipArchive, signatureDocs);
        asicSignature.setName(zipArchive.getName());
        return asicSignature;
    }

    protected boolean isSignatureFilename(String name) {
        return ASiCUtils.isXAdES((String)name);
    }

    private XAdESService getXAdESService() {
        XAdESService xadesService = new XAdESService(this.certificateVerifier);
        xadesService.setTspSource(this.tspSource);
        return xadesService;
    }

    private XAdESSignatureParameters getXAdESParameters(ASiCWithXAdESSignatureParameters parameters, DSSDocument existingXAdESSignatureASiCS) {
        ASiCWithXAdESSignatureParameters xadesParameters = parameters;
        xadesParameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        Document rootDocument = null;
        if (existingXAdESSignatureASiCS != null) {
            rootDocument = DomUtils.buildDOM((DSSDocument)existingXAdESSignatureASiCS);
        } else {
            rootDocument = DomUtils.buildDOM();
            Element xadesSignatures = rootDocument.createElementNS("http://uri.etsi.org/02918/v1.2.1#", "asic:XAdESSignatures");
            rootDocument.appendChild(xadesSignatures);
        }
        xadesParameters.setRootDocument(rootDocument);
        return xadesParameters;
    }

    protected AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithXAdESContainerExtractor(archive);
    }

    protected String getExpectedSignatureExtension() {
        return ".xml";
    }

    static {
        DomUtils.registerNamespace((String)"asic", (String)"http://uri.etsi.org/02918/v1.2.1#");
        DomUtils.registerNamespace((String)"manifest", (String)"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
    }
}

