/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithXAdESManifestBuilder {
    private final List<DSSDocument> documents;

    public ASiCEWithXAdESManifestBuilder(List<DSSDocument> documents) {
        this.documents = documents;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = documentDom.createElementNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:manifest");
        manifestDom.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:version", "1.2");
        documentDom.appendChild(manifestDom);
        Element rootDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (String)"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", (String)"manifest:file-entry");
        rootDom.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:full-path", "/");
        rootDom.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:media-type", MimeType.ASICE.getMimeTypeString());
        for (DSSDocument document : this.documents) {
            Element fileDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (String)"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", (String)"manifest:file-entry");
            fileDom.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:full-path", document.getName());
            MimeType mimeType = document.getMimeType();
            if (mimeType == null) continue;
            fileDom.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:media-type", mimeType.getMimeTypeString());
        }
        return documentDom;
    }
}

