/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.xades.signature.asice.ASiCEWithXAdESManifestBuilder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractDataToSignASiCEWithXAdES {
    private static final String META_INF = "META-INF/";
    private static final String ZIP_ENTRY_ASICE_METAINF_XADES_SIGNATURE = "META-INF/signatures001.xml";

    protected DSSDocument getASiCManifest(List<DSSDocument> documents) {
        ASiCEWithXAdESManifestBuilder manifestBuilder = new ASiCEWithXAdESManifestBuilder(documents);
        return DomUtils.createDssDocumentFromDomDocument((Document)manifestBuilder.build(), (String)"META-INF/manifest.xml");
    }

    protected String getSignatureFileName(ASiCParameters asicParameters, List<DSSDocument> existingSignatures) {
        if (Utils.isStringNotBlank((String)asicParameters.getSignatureFileName())) {
            return META_INF + asicParameters.getSignatureFileName();
        }
        if (Utils.isCollectionNotEmpty(existingSignatures)) {
            return ZIP_ENTRY_ASICE_METAINF_XADES_SIGNATURE.replace("001", this.getSignatureNumber(existingSignatures));
        }
        return ZIP_ENTRY_ASICE_METAINF_XADES_SIGNATURE;
    }

    private String getSignatureNumber(List<DSSDocument> existingSignatures) {
        int signatureNumbre = existingSignatures.size() + 1;
        String sigNumberStr = String.valueOf(signatureNumbre);
        String zeroPad = "000";
        return zeroPad.substring(sigNumberStr.length()) + sigNumberStr;
    }
}

