/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asics;

import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asics.AbstractGetDataToSignASiCSWithXAdES;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCSWithXAdESFromArchive
extends AbstractGetDataToSignASiCSWithXAdES
implements GetDataToSignASiCWithXAdESHelper {
    private final List<DSSDocument> embeddedSignatures;
    private final List<DSSDocument> embeddedSignedFiles;
    private final ASiCParameters asicParameters;

    public DataToSignASiCSWithXAdESFromArchive(List<DSSDocument> embeddedSignatures, List<DSSDocument> embeddedSignedFiles, ASiCParameters asicParameters) {
        this.embeddedSignatures = embeddedSignatures;
        this.embeddedSignedFiles = embeddedSignedFiles;
        this.asicParameters = asicParameters;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.asicParameters);
    }

    @Override
    public List<DSSDocument> getToBeSigned() {
        return this.embeddedSignedFiles;
    }

    @Override
    public DSSDocument getExistingSignature() {
        int nbEmbeddedSignatures = Utils.collectionSize(this.embeddedSignatures);
        if (nbEmbeddedSignatures != 1) {
            throw new DSSException("Unable to select the embedded signature (nb found:" + nbEmbeddedSignatures + ")");
        }
        return this.embeddedSignatures.get(0);
    }

    public List<DSSDocument> getSignedDocuments() {
        int nbSignedFiles = Utils.collectionSize(this.embeddedSignedFiles);
        if (nbSignedFiles != 1) {
            throw new DSSException("Unable to select the document to be signed (nb found:" + nbSignedFiles + ")");
        }
        return this.embeddedSignedFiles;
    }

    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignatures() {
        return this.embeddedSignatures;
    }
}

