/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.validation;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.validation.ASiCEWithXAdESManifestParser;
import eu.europa.esig.dss.asic.xades.validation.XMLDocumentForASiCValidator;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ASiCContainerWithXAdESValidator
extends AbstractASiCContainerValidator {
    ASiCContainerWithXAdESValidator() {
        super(null);
    }

    public ASiCContainerWithXAdESValidator(DSSDocument asicContainer) {
        super(asicContainer);
        this.analyseEntries();
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return ASiCUtils.isASiCContainer((DSSDocument)dssDocument) && ASiCUtils.isArchiveContainsCorrectSignatureFileWithExtension((DSSDocument)dssDocument, (String)".xml");
    }

    protected AbstractASiCContainerExtractor getArchiveExtractor() {
        return new ASiCWithXAdESContainerExtractor(this.document);
    }

    protected List<DocumentValidator> getValidators() {
        if (this.validators == null) {
            this.validators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                XMLDocumentForASiCValidator xadesValidator = new XMLDocumentForASiCValidator(signature);
                xadesValidator.setCertificateVerifier(this.certificateVerifier);
                xadesValidator.setProcessExecutor(this.processExecutor);
                xadesValidator.setValidationCertPool(this.validationCertPool);
                xadesValidator.setSignaturePolicyProvider(this.signaturePolicyProvider);
                if (ASiCUtils.isOpenDocument((DSSDocument)this.getMimeTypeDocument())) {
                    xadesValidator.setDetachedContents(OpenDocumentSupportUtils.getOpenDocumentCoverage(this.extractResult));
                } else {
                    xadesValidator.setDetachedContents(this.getSignedDocuments());
                    xadesValidator.setContainerContents(this.getArchiveDocuments());
                }
                this.validators.add(xadesValidator);
            }
        }
        return this.validators;
    }

    protected List<ManifestFile> getManifestFilesDecriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List signatureDocuments = this.getSignatureDocuments();
        List manifestDocuments = this.getManifestDocuments();
        for (DSSDocument signatureDoc : signatureDocuments) {
            for (DSSDocument manifestDoc : manifestDocuments) {
                ASiCEWithXAdESManifestParser manifestParser = new ASiCEWithXAdESManifestParser(signatureDoc, manifestDoc);
                descriptions.add(manifestParser.getManifest());
            }
        }
        return descriptions;
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        List potentials = this.getSignedDocuments();
        for (DSSDocument signature : this.getSignatureDocuments()) {
            XMLDocumentForASiCValidator xadesValidator = new XMLDocumentForASiCValidator(signature);
            xadesValidator.setCertificateVerifier(this.certificateVerifier);
            xadesValidator.setDetachedContents(potentials);
            List retrievedDocs = xadesValidator.getOriginalDocuments(signatureId);
            if (!Utils.isCollectionNotEmpty((Collection)retrievedDocs)) continue;
            return this.extractArchiveDocuments(retrievedDocs);
        }
        return result;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        XAdESSignature xadesignature = (XAdESSignature)advancedSignature;
        List retrievedDocs = XAdESSignatureUtils.getSignerDocuments((XAdESSignature)xadesignature);
        return this.extractArchiveDocuments(retrievedDocs);
    }

    private List<DSSDocument> extractArchiveDocuments(List<DSSDocument> retrievedDocs) {
        if (Utils.isCollectionNotEmpty((Collection)this.getArchiveDocuments())) {
            return this.getArchiveDocuments();
        }
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        return retrievedDocs;
    }
}

