/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineLT
extends CAdESSignatureExtension {
    private final CertificateVerifier certificateVerifier;
    private final CAdESLevelBaselineT cadesProfileT;

    public CAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier, boolean onlyLastSigner) {
        super(tspSource, onlyLastSigner);
        this.certificateVerifier = certificateVerifier;
        this.cadesProfileT = new CAdESLevelBaselineT(tspSource, onlyLastSigner);
    }

    @Override
    protected SignerInformation extendCMSSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) throws DSSException {
        CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation, this.certificateVerifier.createValidationPool());
        cadesSignature.setDetachedContents(parameters.getDetachedContents());
        if (!cadesSignature.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_T)) {
            signerInformation = this.cadesProfileT.extendCMSSignature(cmsSignedData, signerInformation, parameters);
        }
        return signerInformation;
    }

    @Override
    public CMSSignedData postExtendCMSSignedData(CMSSignedData cmsSignedData, SignerInformation signerInformation, List<DSSDocument> detachedContents) {
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        cmsSignedData = cmsSignedDataBuilder.extendCMSSignedData(cmsSignedData, signerInformation, detachedContents);
        return cmsSignedData;
    }
}

