/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESSignedAttributes;
import eu.europa.esig.dss.cades.validation.CAdESTimestampDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.EncapsulatedCertificateTokenIdentifier;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CMSCRLSource;
import eu.europa.esig.dss.validation.CMSCertificateSource;
import eu.europa.esig.dss.validation.CMSOCSPSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampSource
extends AbstractTimestampSource<CAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampSource.class);
    protected final transient SignerInformation signerInformation;
    protected final transient CMSSignedData cmsSignedData;
    protected final transient List<DSSDocument> detachedDocuments;

    public CAdESTimestampSource(CAdESSignature signature, CertificatePool certificatePool) {
        super((AdvancedSignature)signature);
        this.cmsSignedData = signature.getCmsSignedData();
        this.detachedDocuments = signature.getDetachedContents();
        this.signerInformation = signature.getSignerInformation();
        this.certificatePool = certificatePool;
    }

    protected CAdESTimestampDataBuilder getTimestampDataBuilder() {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(this.cmsSignedData, this.certificatePool.getCertificateTokens(), this.getCertificates());
        return new CAdESTimestampDataBuilder(this.cmsSignedData, this.signerInformation, this.detachedDocuments, timestampExtractor);
    }

    protected SignatureProperties<CAdESAttribute> getSignedSignatureProperties() {
        return CAdESSignedAttributes.build(this.signerInformation);
    }

    protected SignatureProperties<CAdESAttribute> getUnsignedSignatureProperties() {
        return CAdESUnsignedAttributes.build(this.signerInformation);
    }

    protected boolean isContentTimestamp(CAdESAttribute signedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_contentTimestamp.equals((Object)signedAttribute.getASN1Oid());
    }

    protected boolean isAllDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isIndividualDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isSignatureTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certificateRefs.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeCertificateRefsOid.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationRefs.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeRevocationRefsOid.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certValues.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationValues.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return this.isArchiveTimestampV2(unsignedAttribute) || this.isArchiveTimestampV3(unsignedAttribute);
    }

    private boolean isArchiveTimestampV2(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV2.equals((Object)unsignedAttribute.getASN1Oid());
    }

    private boolean isArchiveTimestampV3(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV3.equals((Object)unsignedAttribute.getASN1Oid());
    }

    protected boolean isTimeStampValidationData(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected TimestampToken makeTimestampToken(CAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        ASN1Primitive asn1Primitive = signatureAttribute.getASN1Primitive();
        if (asn1Primitive == null) {
            return null;
        }
        try {
            return new TimestampToken(asn1Primitive.getEncoded(), timestampType, this.certificatePool, references, TimestampLocation.CAdES);
        }
        catch (Exception e) {
            throw new DSSException("Cannot create a timestamp token", (Throwable)e);
        }
    }

    protected List<TimestampedReference> getIndividualContentTimestampedReferences(CAdESAttribute signedAttribute) {
        throw new DSSException("Not applicable for CAdES!");
    }

    protected List<TimestampedReference> getSignedDataReferences(TimestampToken timestampToken) {
        if (ArchiveTimestampType.CAdES_V2.equals((Object)timestampToken.getArchiveTimestampType()) || ArchiveTimestampType.CAdES.equals((Object)timestampToken.getArchiveTimestampType())) {
            return this.getSignatureSignedDataReferences();
        }
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        ASN1Sequence atsHashIndex = DSSASN1Utils.getAtsHashIndex((AttributeTable)timestampToken.getUnsignedAttributes());
        DigestAlgorithm digestAlgorithm = this.getHashIndexDigestAlgorithm(atsHashIndex);
        List<TimestampedReference> certificateReferences = this.getSignedDataCertificateReferences(atsHashIndex, digestAlgorithm, timestampToken.getDSSIdAsString());
        references.addAll(certificateReferences);
        List<TimestampedReference> revocationReferences = this.getSignedDataRevocationReferences(atsHashIndex, digestAlgorithm, timestampToken.getDSSIdAsString());
        references.addAll(revocationReferences);
        return references;
    }

    private List<TimestampedReference> getSignedDataCertificateReferences(ASN1Sequence atsHashIndex, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureCertificateSource instanceof CMSCertificateSource) {
            ASN1Sequence certsHashIndex = DSSASN1Utils.getCertificatesHashIndex((ASN1Sequence)atsHashIndex);
            List certsHashList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)certsHashIndex);
            for (CertificateToken certificate : this.signatureCertificateSource.getKeyInfoCertificates()) {
                if (this.isDigestValuePresent(certificate.getDigest(digestAlgorithm), certsHashList)) {
                    this.addReference(references, new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
                    continue;
                }
                LOG.warn("The certificate with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)certificate.getDSSIdAsString(), (Object)timestampId);
            }
        }
        return references;
    }

    private List<TimestampedReference> getSignedDataRevocationReferences(ASN1Sequence atsHashIndex, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        ASN1Sequence crlsHashIndex = DSSASN1Utils.getCRLHashIndex((ASN1Sequence)atsHashIndex);
        List crlsHashList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)crlsHashIndex);
        if (this.signatureCRLSource instanceof CMSCRLSource) {
            for (CRLBinary crlBinary : ((CMSCRLSource)this.signatureCRLSource).getSignedDataCRLIdentifiers()) {
                if (this.isDigestValuePresent(crlBinary.getDigestValue(digestAlgorithm), crlsHashList)) {
                    this.addReference(references, new TimestampedReference(crlBinary.asXmlId(), TimestampedObjectType.REVOCATION));
                    continue;
                }
                LOG.warn("The CRL Token with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)crlBinary.asXmlId(), (Object)timestampId);
            }
        }
        List<TimestampedReference> ocspReferences = this.getSignedDataOCSPReferences(crlsHashList, digestAlgorithm, timestampId);
        references.addAll(ocspReferences);
        return references;
    }

    private List<TimestampedReference> getSignedDataOCSPReferences(List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureOCSPSource instanceof CMSOCSPSource) {
            for (OCSPResponseBinary ocspResponse : ((CMSOCSPSource)this.signatureOCSPSource).getSignedDataOCSPIdentifiers()) {
                OtherRevocationInfoFormat otherRevocationInfoFormat = new OtherRevocationInfoFormat(ocspResponse.getAsn1ObjectIdentifier(), (ASN1Encodable)DSSASN1Utils.toASN1Primitive((byte[])ocspResponse.getBasicOCSPRespContent()));
                DERTaggedObject derTaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)otherRevocationInfoFormat);
                if (this.isDigestValuePresent(DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)derTaggedObject)), crlsHashList)) {
                    this.addReference(references, new TimestampedReference(ocspResponse.asXmlId(), TimestampedObjectType.REVOCATION));
                    continue;
                }
                LOG.warn("The OCSP Token with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)ocspResponse.asXmlId(), (Object)timestampId);
            }
        }
        return references;
    }

    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureCertificateSource instanceof CMSCertificateSource) {
            this.addReferences(references, this.createReferencesForCertificates(this.signatureCertificateSource.getKeyInfoCertificates()));
        }
        if (this.signatureCRLSource instanceof CMSCRLSource) {
            for (CRLBinary crlBinary : ((CMSCRLSource)this.signatureCRLSource).getSignedDataCRLIdentifiers()) {
                this.addReference(references, new TimestampedReference(crlBinary.asXmlId(), TimestampedObjectType.REVOCATION));
            }
        }
        if (this.signatureOCSPSource instanceof CMSOCSPSource) {
            for (OCSPResponseBinary ocspResponse : ((CMSOCSPSource)this.signatureOCSPSource).getSignedDataOCSPIdentifiers()) {
                this.addReference(references, new TimestampedReference(ocspResponse.asXmlId(), TimestampedObjectType.REVOCATION));
            }
        }
        return references;
    }

    private DigestAlgorithm getHashIndexDigestAlgorithm(ASN1Sequence atsHashIndex) {
        AlgorithmIdentifier algorithmIdentifier = DSSASN1Utils.getAlgorithmIdentifier((ASN1Sequence)atsHashIndex);
        return algorithmIdentifier != null ? DigestAlgorithm.forOID((String)algorithmIdentifier.getAlgorithm().getId()) : CMSUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
    }

    private boolean isDigestValuePresent(byte[] digestValue, List<DEROctetString> hashList) {
        return hashList.contains(new DEROctetString(digestValue));
    }

    protected List<Digest> getCertificateRefDigests(CAdESAttribute unsignedAttribute) {
        ArrayList<Digest> digests = new ArrayList<Digest>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            OtherCertID otherCertId = OtherCertID.getInstance((Object)seq.getObjectAt(ii));
            DigestAlgorithm digestAlgo = DigestAlgorithm.forOID((String)otherCertId.getAlgorithmHash().getAlgorithm().getId());
            digests.add(new Digest(digestAlgo, otherCertId.getCertHash()));
        }
        return digests;
    }

    protected List<Digest> getRevocationRefCRLDigests(CAdESAttribute unsignedAttribute) {
        ArrayList<Digest> digests = new ArrayList<Digest>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            CrlOcspRef otherRefId = CrlOcspRef.getInstance((Object)seq.getObjectAt(ii));
            CrlListID otherCrlIds = otherRefId.getCrlids();
            if (otherCrlIds == null) continue;
            for (CrlValidatedID id : otherCrlIds.getCrls()) {
                OtherHash crlHash = id.getCrlHash();
                if (crlHash == null) continue;
                DigestAlgorithm digestAlgo = DigestAlgorithm.forOID((String)crlHash.getHashAlgorithm().getAlgorithm().getId());
                digests.add(new Digest(digestAlgo, crlHash.getHashValue()));
            }
        }
        return digests;
    }

    protected List<Digest> getRevocationRefOCSPDigests(CAdESAttribute unsignedAttribute) {
        ArrayList<Digest> digests = new ArrayList<Digest>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int i = 0; i < seq.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance((Object)seq.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                OtherHash ocspHash = ocspResponsesID.getOcspRepHash();
                if (ocspHash == null) continue;
                DigestAlgorithm digestAlgo = DigestAlgorithm.forOID((String)ocspHash.getHashAlgorithm().getAlgorithm().getId());
                digests.add(new Digest(digestAlgo, ocspHash.getHashValue()));
            }
        }
        return digests;
    }

    protected List<EncapsulatedCertificateTokenIdentifier> getEncapsulatedCertificateIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<EncapsulatedCertificateTokenIdentifier> certificateIdentifiers = new ArrayList<EncapsulatedCertificateTokenIdentifier>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            Certificate cs = Certificate.getInstance((Object)seq.getObjectAt(ii));
            try {
                certificateIdentifiers.add(new EncapsulatedCertificateTokenIdentifier(cs.getEncoded()));
                continue;
            }
            catch (IOException e) {
                LOG.warn("Unable to parse encapsulated certificate : {}", (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<CRLBinary> crlBinaryIdentifiers = new ArrayList<CRLBinary>();
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues((ASN1Encodable)asn1Object);
        if (revocationValues != null) {
            for (CertificateList revValue : revocationValues.getCrlVals()) {
                try {
                    crlBinaryIdentifiers.add(new CRLBinary(revValue.getEncoded()));
                }
                catch (IOException e) {
                    LOG.warn("Unable to parse revocation value : {}", (Object)e.getMessage());
                }
            }
        }
        return crlBinaryIdentifiers;
    }

    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<OCSPResponseBinary> ocspIdentifiers = new ArrayList<OCSPResponseBinary>();
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues((ASN1Encodable)asn1Object);
        if (revocationValues != null) {
            for (BasicOCSPResponse basicOCSPResponse : revocationValues.getOcspVals()) {
                BasicOCSPResp basicOCSPResp = new BasicOCSPResp(basicOCSPResponse);
                ocspIdentifiers.add(OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp));
            }
        }
        return ocspIdentifiers;
    }

    protected ArchiveTimestampType getArchiveTimestampType(CAdESAttribute unsignedAttribute) {
        if (OID.id_aa_ets_archiveTimestampV2.equals((Object)unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V2;
        }
        if (OID.id_aa_ets_archiveTimestampV3.equals((Object)unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V3;
        }
        return ArchiveTimestampType.CAdES;
    }

    protected void addEncapsulatedValuesFromTimestamp(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        super.addEncapsulatedValuesFromTimestamp(references, timestampedTimestamp);
        TimestampCRLSource timeStampCRLSource = timestampedTimestamp.getCRLSource();
        this.crlSource.addAll((OfflineCRLSource)timeStampCRLSource);
        for (CRLBinary crlBinary : timeStampCRLSource.getCRLBinaryList()) {
            TimestampedReference crlReference = new TimestampedReference(crlBinary.asXmlId(), TimestampedObjectType.REVOCATION);
            this.addReference(references, crlReference);
        }
        for (CRLRef crlRef : timeStampCRLSource.getAllCRLReferences()) {
            CRLBinary crlBinaryIdentifier = this.crlSource.getIdentifier(crlRef);
            if (crlBinaryIdentifier == null) continue;
            TimestampedReference crlReference = new TimestampedReference(crlBinaryIdentifier.asXmlId(), TimestampedObjectType.REVOCATION);
            this.addReference(references, crlReference);
        }
        TimestampOCSPSource timeStampOCSPSource = timestampedTimestamp.getOCSPSource();
        this.ocspSource.addAll((OfflineOCSPSource)timeStampOCSPSource);
        for (OCSPResponseBinary ocspResponse : timeStampOCSPSource.getOCSPResponsesList()) {
            TimestampedReference ocspReference = new TimestampedReference(ocspResponse.asXmlId(), TimestampedObjectType.REVOCATION);
            this.addReference(references, ocspReference);
        }
        for (OCSPRef ocspRef : timeStampOCSPSource.getAllOCSPReferences()) {
            OCSPResponseBinary ocspResponseIdentifier = this.ocspSource.getIdentifier(ocspRef);
            if (ocspResponseIdentifier == null) continue;
            TimestampedReference ocspReference = new TimestampedReference(ocspResponseIdentifier.asXmlId(), TimestampedObjectType.REVOCATION);
            this.addReference(references, ocspReference);
        }
    }
}

