/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSDocumentValidator
extends SignedDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CMSDocumentValidator.class);
    protected CMSSignedData cmsSignedData;

    CMSDocumentValidator() {
        this((SignatureScopeFinder<CAdESSignature>)new CAdESSignatureScopeFinder());
    }

    CMSDocumentValidator(SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
        super(signatureScopeFinder);
    }

    public CMSDocumentValidator(CMSSignedData cmsSignedData) {
        this();
        this.cmsSignedData = cmsSignedData;
    }

    public CMSDocumentValidator(DSSDocument document) {
        this();
        this.document = document;
        this.cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)document);
    }

    protected CMSDocumentValidator(DSSDocument document, SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
        this(signatureScopeFinder);
        this.document = document;
        this.cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)document);
    }

    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        return DSSASN1Utils.isASN1SequenceTag((byte)firstByte);
    }

    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cmsSignedData != null) {
            for (Object signerInformationObject : this.cmsSignedData.getSignerInfos().getSigners()) {
                SignerInformation signerInformation = (SignerInformation)signerInformationObject;
                CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.validationCertPool);
                if (this.document != null) {
                    cadesSignature.setSignatureFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setContainerContents(this.containerContents);
                cadesSignature.setManifestFiles(this.manifestFiles);
                cadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
                signatures.add((AdvancedSignature)cadesSignature);
            }
        }
        return signatures;
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        if (Utils.isStringBlank((String)signatureId)) {
            throw new NullPointerException("signatureId");
        }
        ArrayList<DSSDocument> results = new ArrayList<DSSDocument>();
        for (Object signerInformationObject : this.cmsSignedData.getSignerInfos().getSigners()) {
            SignerInformation signerInformation = (SignerInformation)signerInformationObject;
            CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.validationCertPool);
            cadesSignature.setSignatureFilename(this.document.getName());
            cadesSignature.setDetachedContents(this.detachedContents);
            cadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
            if (!Utils.areStringsEqual((String)cadesSignature.getId(), (String)signatureId)) continue;
            results.add(cadesSignature.getOriginalDocument());
        }
        return results;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) throws DSSException {
        CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
        try {
            return Arrays.asList(cadesSignature.getOriginalDocument());
        }
        catch (DSSException e) {
            LOG.error("Cannot retrieve a list of original documents");
            return Collections.emptyList();
        }
    }
}

