/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampValidator;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;

public class CMSTimestampValidator
extends CMSDocumentValidator
implements TimestampValidator {
    private final TimeStampToken bcToken;
    private final TimestampType type;
    private DSSDocument timestampedData;

    public CMSTimestampValidator(DSSDocument timestamp) {
        this(timestamp, (TimestampType)null);
    }

    public CMSTimestampValidator(DSSDocument timestamp, TimestampType type) {
        super(timestamp);
        try {
            this.bcToken = new TimeStampToken(this.cmsSignedData);
            this.type = type;
        }
        catch (IOException | TSPException e) {
            throw new DSSException("Unable to parse timestamp", e);
        }
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        return Collections.emptyList();
    }

    public TimestampToken getTimestamp() {
        TimestampToken timestampToken = new TimestampToken(this.bcToken, this.type, this.validationCertPool);
        timestampToken.matchData(DSSUtils.toByteArray((DSSDocument)this.timestampedData));
        return timestampToken;
    }

    public void setTimestampedData(DSSDocument timestampedData) {
        this.timestampedData = timestampedData;
    }
}

